/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.form.FormNumber;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.tools.Lib_Parser;

public class LineBuffer {
    private final String[] liste;
    private final int len;
    private final String filename;
    private int next = 0;
    private int depth = 0;
    private int downchanged = 0;

    public LineBuffer(String filename, String[] liste) {
        this.filename = filename;
        this.liste = liste;
        this.len = liste.length;
    }

    public DebugInfo gDebugInfo() {
        String f = this.filename == null || this.filename.length() == 0 ? null : this.filename;
        return new DebugInfo(f, this.next);
    }

    public String getNext() {
        this.downchanged = 0;
        String s = this.liste[this.next];
        ++this.next;
        this.depth = Lib_Parser.getDepth(s);
        s = s.trim();
        return s;
    }

    public boolean hasNext() {
        while (this.next < this.len && this.liste[this.next] == null) {
            ++this.next;
        }
        return this.next < this.len;
    }

    public void levelDownchanged() {
        ++this.downchanged;
    }

    public int nextLevelDiff() {
        while (this.next < this.len && this.liste[this.next] == null) {
            ++this.next;
        }
        if (this.next == this.len) {
            return 0;
        }
        int depthOld = this.depth;
        int depthNew = Lib_Parser.getDepth(this.liste[this.next]);
        if (depthNew == depthOld) {
            return 0;
        }
        int result = depthNew - depthOld;
        return result + this.downchanged;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.len) {
            String prefix = i == this.next + 1 ? "->" : "  ";
            String depth = i == this.next + 1 ? FormNumber.right(2, this.depth) : "  ";
            prefix = String.valueOf(depth) + " " + prefix + " ";
            sb.append(String.valueOf(prefix) + this.liste[i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

