/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.sys.MOut;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.struct.runtime.VarConstEnv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Par;
import org.jmo_lang.tools.Lib_Parser;

public class CurProc {
    public final Instance instance;
    public final Call call;
    public final VarConstEnv vce;

    public CurProc(Instance instance) {
        this(instance, null, null, true);
    }

    private CurProc(Instance instance, Call call, VarConstEnv parentVCE, boolean varEnvNew) {
        this.instance = instance;
        this.call = call;
        this.vce = varEnvNew ? new VarConstEnv(parentVCE) : parentVCE;
    }

    public CurProc copyCall(Call c, boolean newVarEnv) {
        return new CurProc(this.instance, c, this.vce, newVarEnv);
    }

    public CurProc copyVCE(VarConstEnv base_vce, boolean varEnvNew) {
        return new CurProc(this.instance, this.call, base_vce, varEnvNew);
    }

    public void describe(int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + "CurProc " + this.hashCode());
        space = Lib_Parser.space(++left);
        MOut.text(String.valueOf(space) + "Instance: " + this.instance.toDebug(this));
        MOut.text(String.valueOf(space) + "Call: " + (this.call == null ? "null" : this.call.toDebug(this)));
        if (this.call != null) {
            MOut.text(String.valueOf(space) + "SurrBlock: " + this.call.getSurrounding());
            MOut.text(String.valueOf(space) + "Method: " + this.getMethod());
            MOut.text(String.valueOf(space) + "CallBlock: " + this.call.getCallBlock());
            MOut.text(String.valueOf(space) + "Vars (Types): ");
            if (this.getSurrBlock() != null && this.getSurrBlock().gVarManager() != null) {
                this.getSurrBlock().gVarManager().describe(left + 2);
            } else {
                MOut.text(String.valueOf(space) + "  none");
            }
        }
        MOut.text(String.valueOf(space) + "Vars (Runtime):");
    }

    public String toString() {
        String sc = this.call == null ? "null" : this.call.toString();
        return sc + " | " + this.instance.toString() + " | " + this.vce.toString();
    }

    public App getApp() {
        return this.instance.gApp();
    }

    public Block getCallBlock() {
        return this.call.getCallBlock();
    }

    public DebugInfo getDebugInfo() {
        return this.call.getDebugInfo();
    }

    public String getMethod() {
        return this.call.getMethod();
    }

    public Call getStream() {
        return this.call.getStream();
    }

    public Block getSurrBlock() {
        return this.call.getSurrounding();
    }

    public Type getType() {
        return this.instance.getType();
    }

    public VarConstEnv getVCE() {
        return this.vce;
    }

    public I_Object[] pars() {
        Lib_Par.checkNoBlock(this);
        return Lib_Par.checkPars(this, null, null, new Class[0]);
    }

    public I_Object[] pars(I_Object itStream, Class<?> ... types) {
        Lib_Par.checkNoBlock(this);
        return Lib_Par.checkPars(this, itStream, null, types);
    }

    public I_Object[] parsEach(I_Object itStream, I_Object itEach, Class<?> ... types) {
        Lib_Par.checkNoBlock(this);
        return Lib_Par.checkPars(this, itStream, itEach, types);
    }

    public I_Object[] parsExt(I_Object itStream, Class<?>[] ... types) {
        Lib_Par.checkNoBlock(this);
        return Lib_Par.checkParsExt(this, itStream, types);
    }

    public I_Object[] parsFlex(I_Object itStream, int par_min, int par_max, boolean blockAllowed) {
        if (!blockAllowed) {
            Lib_Par.checkNoBlock(this);
        }
        return Lib_Par.checkParsFlex(this, itStream, par_min, par_max);
    }

    public I_Object[] parsWithBlock(I_Object itStream, Class<?> ... types) {
        return Lib_Par.checkPars(this, itStream, null, types);
    }

    public I_Object par(I_Object par) {
        return Lib_Convert.getValue(this, par);
    }

    public I_Object parType(I_Object par, Class<?> type) {
        return Lib_Par.checkPar(this, par, type);
    }

    public I_Object parType(I_Object par, Class<?> ... type) {
        return Lib_Par.checkParExt(this, par, type);
    }
}

