/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;

public class ParseObj_Dec
implements I_ParseObject {
    private static final String regex = "^([-]?[0-9]+[\\.df][0-9]+).*$";

    @Override
    public boolean hits(char c0, Block current, String s) {
        return (c0 == '-' || c0 >= '0' && c0 <= '9') && s.matches(regex);
    }

    @Override
    public Group2<I_Object, String> parse(App app, Block current, String s, DebugInfo debugInfo) {
        String nr = s.replaceFirst(regex, "$1");
        String rem = s.substring(nr.length());
        char[] chars = nr.toCharArray();
        int pos = 0;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '.') {
                double d = Double.parseDouble(nr);
                return new Group2<I_Object, String>(new Dec(d), rem);
            }
            if (c == 'f') {
                chars[pos] = 46;
                float f = Float.parseFloat(new String(chars));
                return new Group2<I_Object, String>(new JMo_Float(f), rem);
            }
            if (c == 'd') {
                chars[pos] = 46;
                double d = Double.parseDouble(new String(chars));
                return new Group2<I_Object, String>(new Dec(d), rem);
            }
            ++pos;
            ++n2;
        }
        throw Err.impossible(s, nr);
    }
}

