/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.filter.FilterText;
import java.util.regex.Matcher;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.Parser_Block;
import org.jmo_lang.struct.App;
import org.jmo_lang.tools.LineBuffer;

public class Parser_Script {
    public static void parse(App app, String filename, String text) {
        String[] lines = text.split(System.getProperty("line.separator"));
        Parser_Script.iFilterLines(lines, filename);
        Parser_Script.iCombineLines(lines);
        LineBuffer buffer = new LineBuffer(filename, lines);
        Parser_Block parserBlock = new Parser_Block();
        parserBlock.parse(app, app.gRootType(), null, app.gRootType().getBlock(), buffer);
    }

    private static void iCombineLines(String[] lines) {
        int max;
        int i = max = lines.length - 1;
        while (i >= 0) {
            String s = lines[i];
            if (s != null) {
                if (i != max && s.indexOf(44) > 0 && s.matches("^.*[,]\\s*$")) {
                    int n = i;
                    lines[n] = String.valueOf(lines[n]) + lines[i + 1].trim();
                    lines[i + 1] = null;
                }
                String sTrim = s.trim();
                if (i != 0 && sTrim.length() > 0 && "\\+\\*/.\\],".indexOf(sTrim.charAt(0)) >= 0) {
                    int depth2;
                    int depth1 = lines[i].replaceFirst("^([\\t]*).*$", "$1").length();
                    String last = lines[i - 1];
                    if (last != null && depth1 == (depth2 = last.replaceFirst("^([\\t]*).*$", "$1").length())) {
                        int n = i - 1;
                        lines[n] = String.valueOf(lines[n]) + s.trim();
                        lines[i] = null;
                    }
                }
            }
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void iFilterLines(String[] lines, String filename) {
        block_comment = false;
        ignore = false;
        textblock = null;
        i = 0;
        while (i < lines.length) {
            s = lines[i];
            if (!block_comment) ** GOTO lbl14
            idx = s.indexOf("*/");
            if (idx < 0) {
                lines[i] = null;
            } else {
                lines[i] = s.substring(idx + 2);
                block_comment = false;
lbl14:
                // 2 sources

                if (textblock != null) {
                    if (s.startsWith("\"\"\"\"")) {
                        textblock.deleteCharAt(textblock.length() - 1);
                        tb = textblock.toString();
                        tb = FilterText.replace("\\", Matcher.quoteReplacement("\\\\"), tb);
                        tb = FilterText.replace("\"", Matcher.quoteReplacement("\\\""), tb);
                        lines[i] = "\"" + tb.toString() + s.substring(3);
                        textblock = null;
                    } else {
                        textblock.append(String.valueOf(s) + '\n');
                        lines[i] = null;
                    }
                } else {
                    sTrim = s.trim();
                    if (sTrim.startsWith("/*")) {
                        lines[i] = null;
                        block_comment = true;
                    } else if (s.startsWith("\"\"\"\"") && sTrim.length() == 4) {
                        textblock = new StringBuilder();
                        lines[i] = null;
                    } else {
                        if (ignore || s.startsWith("#**#")) {
                            lines[i] = null;
                            ignore = true;
                        }
                        if (sTrim.length() == 0 || sTrim.charAt(0) == '#') {
                            lines[i] = null;
                        } else if (s.startsWith(" ")) {
                            throw new ParseError("Line starts with Space-Char(s)", s, new DebugInfo(filename, i + 1));
                        }
                    }
                }
            }
            ++i;
        }
    }
}

