/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.sys;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.stream.StreamToUTF8;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.cmd.SysCmd;
import de.mn77.base.sys.cmd.SysCmd_Data;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.Nil;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.sys.A_Object_Sys;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;

public class Cmd
extends A_Object_Sys {
    private final String cmd;
    private final Call cmdo;

    public Cmd(Call c) {
        this.cmd = null;
        this.cmdo = c;
    }

    public Cmd(String s) {
        this.cmd = s;
        this.cmdo = null;
    }

    @Override
    public Result_Obj call3(CurProc cp, String method) {
        switch (method) {
            case "exec": {
                return Cmd.stdResult(this.exec(cp));
            }
            case "result": {
                return Cmd.stdResult(this.result(cp));
            }
            case "forget": {
                return Cmd.stdResult(this.forget(cp));
            }
            case "output": 
            case "out": {
                return Cmd.stdResult(this.output(cp));
            }
            case "lines": {
                return Cmd.stdResult(this.lines(cp));
            }
        }
        return null;
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    @Override
    public I_Object exec(CurProc cp) {
        I_Object[] oa = cp.parsFlex(this, 0, 2, false);
        boolean output = oa.length >= 1 ? Lib_Convert.getBoolValue(cp, oa[0]) : true;
        boolean wait = oa.length == 2 ? Lib_Convert.getBoolValue(cp, oa[1]) : true;
        Group2<SysCmd_Data, StreamToUTF8> res = this.run(cp, wait);
        if (output) {
            System.out.print(res.g2().getString());
        }
        return wait ? new Int(res.g1().result.get()) : Nil.NIL;
    }

    public I_Object forget(CurProc cp) {
        cp.pars(this, new Class[0]);
        this.run(cp, false);
        return Nil.NIL;
    }

    public JMo_List lines(CurProc cp) {
        cp.pars();
        StreamToUTF8 info = this.run(cp, true).g2();
        String[] sa = info.getString().split("\n");
        JMo_List list = new JMo_List();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.internalAdd(new Str(s));
            ++n2;
        }
        return list;
    }

    public Str output(CurProc cp) {
        cp.pars();
        StreamToUTF8 info = this.run(cp, true).g2();
        return new Str(info.getString());
    }

    public Int result(CurProc cp) {
        cp.pars();
        MOut.debug("result: " + this.toString());
        SysCmd_Data info = this.run(cp, true).g1();
        return new Int(info.result.get());
    }

    @Override
    public I_Object standaloneExec(CurProc cp) {
        return this.exec(cp);
    }

    @Override
    public String toDebug(CurProc cp) {
        return "Command(\"" + this.toString() + "\")";
    }

    @Override
    public String toString() {
        return this.cmd != null ? this.cmd : this.cmdo.toString();
    }

    private Group2<SysCmd_Data, StreamToUTF8> run(CurProc cp, boolean wait) {
        String c = this.cmd;
        if (this.cmd == null) {
            I_Object o = this.cmdo.exec(cp, null);
            MOut.debug(this.cmdo, o, o.getClass().getSimpleName());
            c = ((Str)o).gValue();
        }
        try {
            SysCmd_Data info = new SysCmd_Data();
            info.command.set(c);
            info.wait.set(wait);
            StreamToUTF8 outStream = new StreamToUTF8();
            info.streamOutput.set(outStream);
            try {
                SysCmd start = new SysCmd();
                start.start(info);
            }
            catch (Err_Exception f) {
                return new Group2<SysCmd_Data, StreamToUTF8>(info, outStream);
            }
            return new Group2<SysCmd_Data, StreamToUTF8>(info, outStream);
        }
        catch (Exception e) {
            throw Err.show(e, false);
        }
    }
}

