/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.error.Err;
import java.io.File;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.A_FileSys;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;

public class JMo_Path
extends A_Object
implements I_Object {
    private final Call par;
    private A_FileSys path = null;

    public JMo_Path(Call par) {
        Err.ifNull(par);
        this.par = par;
    }

    @Override
    public void init(CurProc cp) {
        I_Object filename = this.par.exec(cp, null);
        if (!((filename = Lib_Convert.getValue(cp, filename)) instanceof Str)) {
            throw Err.invalid(filename.toDebug(cp));
        }
        String filestr = ((Str)filename).gValue();
        File item = new File(filestr);
        this.path = item.isDirectory() ? new JMo_Dir(item) : new JMo_File(item);
        this.path.init(cp);
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        return new Result_Obj(this.path.call(cp), true);
    }

    @Override
    public int compareTo(I_Object o) {
        return this.path.compareTo(o);
    }

    @Override
    public String toDebug(CurProc cp) {
        if (this.path != null) {
            return this.path.toDebug(cp);
        }
        String p = Lib_Output.toDebug(cp, this.par);
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        return "Path" + p;
    }

    @Override
    public String toString() {
        return this.path.toString();
    }
}

