/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.datetime;

import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_Date
extends A_Object {
    private MDate date;
    private final Call[] init;

    public JMo_Date() {
        this.init = null;
    }

    public JMo_Date(Call str) {
        this.init = new Call[]{str};
    }

    public JMo_Date(Call y, Call m, Call d) {
        this.init = new Call[]{y, m, d};
    }

    @Override
    public void init(CurProc cp) {
        if (this.init == null) {
            this.date = new MDate();
        } else if (this.init.length == 1) {
            String s = Lib_Convert.getStringValue(cp, this.init[0].exec(cp, null));
            this.date = new MDate(s);
        } else {
            int iy = Lib_Convert.getIntValue(cp, this.init[0].exec(cp, null));
            int im = Lib_Convert.getIntValue(cp, this.init[1].exec(cp, null));
            int id = Lib_Convert.getIntValue(cp, this.init[2].exec(cp, null));
            this.date = new MDate(iy, im, id);
        }
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        switch (cp.getMethod()) {
            case "getYear": 
            case "year": {
                return JMo_Date.stdResult(this.gYear(cp));
            }
            case "month": 
            case "getMonth": {
                return JMo_Date.stdResult(this.gMonth(cp));
            }
            case "getDay": 
            case "day": {
                return JMo_Date.stdResult(this.gDay(cp));
            }
            case "toStr": {
                return JMo_Date.stdResult(this.toStr(cp));
            }
            case "format": {
                return JMo_Date.stdResult(this.format(cp));
            }
            case "diffDays": {
                return JMo_Date.stdResult(this.diffDays(cp));
            }
            case "diffMonths": {
                return JMo_Date.stdResult(this.diffMonths(cp));
            }
            case "diffYears": {
                return JMo_Date.stdResult(this.diffYears(cp));
            }
            case "==": {
                return JMo_Date.stdResult(this.compare(cp, COMPARE.E));
            }
            case "!=": {
                return JMo_Date.stdResult(this.compare(cp, COMPARE.NE));
            }
            case ">": {
                return JMo_Date.stdResult(this.compare(cp, COMPARE.G));
            }
            case "<": {
                return JMo_Date.stdResult(this.compare(cp, COMPARE.L));
            }
            case ">=": {
                return JMo_Date.stdResult(this.compare(cp, COMPARE.GE));
            }
            case "<=": {
                return JMo_Date.stdResult(this.compare(cp, COMPARE.LE));
            }
        }
        return null;
    }

    @Override
    public void describe(CurProc cp, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cp));
    }

    @Override
    public String toDebug(CurProc cp) {
        if (this.date == null) {
            return "Date";
        }
        return "Date(" + this.toString() + ")";
    }

    @Override
    public String toString() {
        if (this.date == null) {
            return "Date";
        }
        return this.date.toString();
    }

    private Bool compare(CurProc cp, COMPARE co) {
        JMo_Date d = (JMo_Date)cp.pars(this, JMo_Date.class)[0];
        boolean isEqual = this.date.isEqual(d.getInternalValue());
        boolean isGreater = this.date.isGreater(d.getInternalValue());
        boolean result = false;
        switch (co) {
            case E: {
                result = isEqual;
            }
            case NE: {
                result = !isEqual;
            }
            case L: {
                result = !isEqual && !isGreater;
            }
            case LE: {
                result = isEqual || !isGreater;
            }
            case G: {
                result = isGreater;
            }
            case GE: {
                result = isEqual || isGreater;
            }
        }
        return Bool.getObject(result);
    }

    private Int diffDays(CurProc cp) {
        JMo_Date par = (JMo_Date)cp.pars(this, JMo_Date.class)[0];
        int diff = this.date.diffDays(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffMonths(CurProc cp) {
        JMo_Date par = (JMo_Date)cp.pars(this, JMo_Date.class)[0];
        int diff = this.date.diffMonths(par.getInternalValue());
        return new Int(diff);
    }

    private Int diffYears(CurProc cp) {
        JMo_Date par = (JMo_Date)cp.pars(this, JMo_Date.class)[0];
        int diff = this.date.diffYears(par.getInternalValue());
        return new Int(diff);
    }

    private I_Object format(CurProc cp) {
        String s = ((Str)cp.pars(this, Str.class)[0]).gValue();
        StringBuilder sb = new StringBuilder();
        s = s.toLowerCase();
        while (s.length() > 0) {
            int move = 0;
            if (s.startsWith("yyyy")) {
                sb.append(FormNumber.width(4, this.date.getYear(), false));
                move = 4;
            } else if (s.startsWith("yy")) {
                String tmp = "" + this.date.getYear();
                if (tmp.length() >= 2) {
                    sb.append(tmp.substring(tmp.length() - 2, tmp.length()));
                } else {
                    sb.append(FormNumber.width(2, tmp, false));
                }
                move = 2;
            } else if (s.startsWith("y")) {
                sb.append("" + this.date.getYear());
                move = 1;
            } else if (s.startsWith("mm")) {
                sb.append(FormNumber.width(2, this.date.getMonth(), false));
                move = 2;
            } else if (s.startsWith("m")) {
                sb.append("" + this.date.getMonth());
                move = 1;
            } else if (s.startsWith("dd")) {
                sb.append(FormNumber.width(2, this.date.getDay(), false));
                move = 2;
            } else if (s.startsWith("d")) {
                sb.append("" + this.date.getDay());
                move = 1;
            } else {
                sb.append(s.charAt(0));
                move = 1;
            }
            Err.ifEqual(move, 0);
            s = s.substring(move);
        }
        return new Str(sb.toString());
    }

    private Int gDay(CurProc cp) {
        cp.pars();
        return new Int(this.date.getDay());
    }

    private MDate getInternalValue() {
        return this.date;
    }

    private Int gMonth(CurProc cp) {
        cp.pars();
        return new Int(this.date.getMonth());
    }

    private Int gYear(CurProc cp) {
        cp.pars();
        return new Int(this.date.getYear());
    }

    private I_Object toStr(CurProc cp) {
        cp.pars();
        return new Str(this.date.toString());
    }
}

