/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.base.thread.A_Thread;
import java.util.ArrayList;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_AutoObject;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.Nil;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.passthrough.I_Passthrough;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Error;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.MethodList;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Par;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Prio;

public abstract class A_Object
implements I_Object {
    @Override
    public final I_Object call(CurProc cp) {
        String method = cp.getMethod();
        boolean streamPrio = Lib_Prio.streamPrio(cp.call);
        Result_Obj result = null;
        if (method == null) {
            I_Object obj;
            if (cp.call.getCallBlock() != null) {
                result = this.autoBlockFunction(cp);
                if (result.is_Attachment_Exec) {
                    return result.obj;
                }
            }
            if ((obj = this.standaloneExec(cp)) != null) {
                return obj;
            }
            return this;
        }
        boolean pass = this instanceof I_Passthrough;
        if (!pass && streamPrio) {
            cp.call.execStream(cp, cp.pars(this, I_Object.class)[0]);
        }
        if ((result = pass ? this.call2(cp) : this.iCall(cp, method)) == null) {
            throw new ExecError(cp, "Unknown Function", String.valueOf(this.getTypeName()) + "." + method);
        }
        if (result.is_Attachment_Exec) {
            return result.obj;
        }
        if (result.obj == null) {
            Err.todo("Result-Object is null", cp.getDebugInfo());
        }
        I_Object currentresult = result.obj;
        if (cp.getCallBlock() != null) {
            try {
                currentresult = cp.getCallBlock().exec(cp, currentresult);
            }
            catch (ReturnException e) {
                return e.get();
            }
        }
        if (!streamPrio && cp.getStream() != null) {
            return cp.call.execStream(cp, currentresult);
        }
        if (result != null && currentresult != null) {
            return currentresult;
        }
        throw Err.todo(method);
    }

    private Result_Obj iCall(CurProc cp, String method) {
        switch (method) {
            case "\u00bf": {
                this.hint(cp, false);
                return A_Object.stdResult(this);
            }
            case "(\u00bf": {
                this.hint(cp, true);
                return A_Object.stdResult(this);
            }
            case "type": {
                cp.pars();
                return A_Object.stdResult(new Str(this.getTypeName()));
            }
            case "types": {
                cp.pars();
                return A_Object.stdResult(this.types());
            }
            case "isNil": {
                return A_Object.stdResult(this.isNil(cp));
            }
            case "ifNil": {
                return A_Object.stdResult(this.ifNil(cp));
            }
            case "print": {
                return A_Object.stdResult(this.print(cp, true));
            }
            case "echo": {
                return A_Object.stdResult(this.print(cp, false));
            }
            case "proc": {
                return this.proc(cp);
            }
            case "tee": {
                return this.tee(cp);
            }
            case "case": {
                return this.switch_case(cp);
            }
            case "do": 
            case "default": {
                return this.switch_default(cp);
            }
            case "try": {
                return this.errTry(cp);
            }
            case "catch": {
                return this.errCatch(cp);
            }
            case "mem": {
                this.mem_let(cp, true);
                return A_Object.stdResult(this);
            }
            case "let": {
                this.mem_let(cp, false);
                return A_Object.stdResult(this);
            }
            case "sync": {
                return this.sync(cp);
            }
            case "async": {
                return this.async(cp);
            }
            case "endLoop": {
                return this.endLoop(cp);
            }
        }
        return this.call2(cp);
    }

    @Override
    public abstract String toString();

    protected abstract Result_Obj call2(CurProc var1);

    @Override
    public void init(CurProc cp) {
    }

    public Result_Obj autoBlockFunction(CurProc cp) {
        throw new ParseError(cp, "No Block allowed for raw object", "This type don't have an AutoBlockFunction: " + this.getTypeName());
    }

    public I_Object standaloneExec(CurProc cp) {
        return null;
    }

    public I_Object print(CurProc cp, boolean newline) {
        I_Object[] pars = cp.parsFlex(this, 0, 1, false);
        String s = null;
        s = pars == null || pars.length == 0 ? this.toString() : pars[0].toString();
        Lib_Output.out(cp.getApp(), s, newline);
        return this;
    }

    @Override
    public int compareTo(I_Object o) {
        if (o.hashCode() == this.hashCode()) {
            return 0;
        }
        throw Err.todo(o);
    }

    @Override
    public void describe(CurProc cp, int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + this.toDebug(cp));
    }

    @Override
    public final String getTypeName() {
        Class<?> cl = this.getClass();
        return Lib_Convert.typeName(cl, this);
    }

    @Override
    public final String[] getTypes() {
        ArrayList<String> list = new ArrayList<String>();
        Class<?> cl = this.getClass();
        while (cl != null) {
            String s = cl.getName();
            if (s.startsWith("org.jmo_lang")) {
                s = Lib_Convert.typeName(cl, this);
                if (s.equals("Var")) {
                    MOut.exit(cl, s);
                }
                list.add(s);
            }
            cl = cl.getSuperclass();
        }
        return list.toArray(new String[list.size()]);
    }

    protected static Result_Obj stdResult(I_Object result) {
        return new Result_Obj(result, false);
    }

    private Result_Obj async(final CurProc cp) {
        final A_Object this2 = this;
        A_Thread t = new A_Thread(){

            @Override
            public void task() {
                I_Object it;
                I_Object[] pars = cp.parsFlex(this2, 0, 1, true);
                Call stream = cp.getStream();
                Block block = cp.getCallBlock();
                int parlen = pars.length;
                if (parlen == 0 && stream == null && block == null) {
                    throw new ExecError(cp, "Wrong call", "No Parameter, no Stream, no Block, for times ... what to do?");
                }
                I_Object i_Object = it = parlen == 0 ? this2 : pars[0];
                if (block != null) {
                    try {
                        block.exec(cp, it);
                    }
                    catch (ReturnException e) {
                        Return temp = e.get();
                        temp.getResult();
                        switch (temp.getLevel()) {
                            case BREAK: {
                                return;
                            }
                        }
                        throw new ExecError(cp, "Wrong exit for block", "Got " + (Object)((Object)temp.getLevel()) + ", need " + (Object)((Object)Return.LEVEL.BREAK));
                    }
                }
                if (stream != null) {
                    stream.exec(cp, it);
                }
            }
        };
        t.start();
        return new Result_Obj(Nil.NIL, true);
    }

    private Result_Obj endLoop(CurProc cp) {
        Var v = (Var)cp.getSurrBlock().gVarManager().use("xInternalLoopVar");
        JMo_List vl = null;
        if (cp.vce.vars.isInitialized(v)) {
            vl = (JMo_List)v.get(cp);
        } else {
            vl = new JMo_List();
            v.set(cp, cp, vl);
        }
        vl.internalAdd(this);
        return new Result_Obj(vl, true);
    }

    private Result_Obj errTry(CurProc cp) {
        I_Object res;
        Block block;
        Call stream;
        block7: {
            cp.parsWithBlock(this, new Class[0]);
            stream = cp.getStream();
            block = cp.getCallBlock();
            res = this;
            try {
                if (block != null) {
                    try {
                        res = block.exec(cp, res);
                        break block7;
                    }
                    catch (ReturnException e) {
                        return new Result_Obj(e.get(), true);
                    }
                }
                if (stream != null) {
                    res = stream.exec(cp, this);
                }
            }
            catch (ErrorBaseDebug t) {
                res = new Error(t);
            }
        }
        if (block != null && stream != null) {
            res = stream.exec(cp, res);
        }
        return new Result_Obj(res, true);
    }

    private Result_Obj errCatch(CurProc cp) {
        cp.parsWithBlock(this, new Class[0]);
        Call stream = cp.getStream();
        Block block = cp.getCallBlock();
        I_Object res = this;
        if (this instanceof Error) {
            if (block != null) {
                try {
                    res = block.exec(cp, res);
                }
                catch (ReturnException e) {
                    return new Result_Obj(e.get(), true);
                }
            }
            if (stream != null) {
                res = stream.exec(cp, res);
            }
        }
        return new Result_Obj(res, true);
    }

    private void hint(CurProc cp, boolean pars) {
        Str search = (Str)cp.pars(this, Str.class)[0];
        MethodList ml = new MethodList();
        if (this instanceof A_AutoObject) {
            ((A_AutoObject)this).getMethods(ml);
        }
        HintManager hints = cp.getApp().gHints();
        if (pars) {
            hints.searchFuncPars(ml, this.getTypeName(), search.gValue());
        } else {
            hints.searchFunc(ml, this.getTypeName(), search.gValue());
        }
        String result = pars ? ml.getPars(search.gValue()) : ml.get(search.gValue());
        Lib_Output.out(cp.getApp(), result, true);
    }

    private I_Object ifNil(CurProc cp) {
        I_Object o = cp.pars(this, I_Object.class)[0];
        return this == Nil.NIL ? o : this;
    }

    private I_Object iProcTeeBlock(CurProc cp) {
        I_Object par;
        I_Object[] pars = cp.parsFlex(this, 0, 1, true);
        Block block = cp.getCallBlock();
        I_Object i_Object = par = pars == null || pars.length == 0 ? null : pars[0];
        if (block == null && par == null) {
            throw new ExecError(cp, "A 'process' without parameter and block makes no sense!", "");
        }
        I_Object res = this;
        if (par != null) {
            res = par;
        }
        if (block != null) {
            try {
                res = block.exec(cp, res);
            }
            catch (ReturnException e) {
                return e.get();
            }
        }
        return res;
    }

    private Bool isNil(CurProc cp) {
        cp.pars();
        return Bool.getObject(this == Nil.NIL);
    }

    private void mem_let(CurProc cp, boolean mem) {
        Lib_Par.checkNoBlock(cp);
        I_Object[] pars = cp.call.getPars(cp, this, null);
        if (pars.length != 1) {
            throw new ParseError(cp, "Wrong Parameter-Count", "Got " + pars.length + " Pars, expected one Var");
        }
        if (mem) {
            I_Object par = cp.parType(pars[0], (Class<?>)VarLet.class);
            Var o = ((VarLet)par).getVar();
            o.set(cp, cp, this);
        } else {
            this.iCheckParIsVar(cp, this, false);
            Var o = (Var)this;
            o.set(cp, cp, pars[0]);
        }
    }

    private Result_Obj proc(CurProc cp) {
        Call stream = cp.getStream();
        I_Object res = this.iProcTeeBlock(cp);
        if (stream != null) {
            res = stream.exec(cp, res);
        }
        return new Result_Obj(res, true);
    }

    private Result_Obj switch_case(CurProc cp) {
        Bool par = (Bool)cp.parsWithBlock(this, Bool.class)[0];
        Call stream = cp.getStream();
        Block block = cp.getCallBlock();
        if (block == null) {
            throw new ExecError(cp, "A 'case' without block makes no sense!", "");
        }
        I_Object res = this;
        if (par.gValue().booleanValue()) {
            try {
                res = block.exec(cp, res);
            }
            catch (ReturnException e) {
                res = e.get();
            }
            return new Result_Obj(res, true);
        }
        if (stream != null) {
            res = stream.exec(cp, this);
        }
        return new Result_Obj(res, true);
    }

    private Result_Obj switch_default(CurProc cp) {
        cp.parsWithBlock(this, new Class[0]);
        Call stream = cp.getStream();
        Block block = cp.getCallBlock();
        if (block == null && stream == null) {
            throw new ExecError(cp, "A 'default' without block and stream makes no sense!", "");
        }
        I_Object res = this;
        if (block != null) {
            try {
                res = block.exec(cp, res);
            }
            catch (ReturnException e) {
                res = e.get();
            }
        }
        if (stream != null) {
            res = stream.exec(cp, this);
        }
        return new Result_Obj(res, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result_Obj sync(CurProc cp) {
        A_Object a_Object = this;
        synchronized (a_Object) {
            A_Object it;
            I_Object[] pars = cp.parsFlex(this, 0, 1, true);
            Call stream = cp.getStream();
            Block block = cp.getCallBlock();
            int parlen = pars.length;
            if (parlen == 0 && stream == null && block == null) {
                throw new ExecError(cp, "Wrong call", "No Parameter, no Stream, no Block, for times ... what to do?");
            }
            I_Object res = this;
            I_Object i_Object = it = parlen == 0 ? this : pars[0];
            if (block != null) {
                try {
                    res = block.exec(cp, it);
                }
                catch (ReturnException e) {
                    Return temp = e.get();
                    res = temp.getResult();
                    switch (temp.getLevel()) {
                        case BREAK: {
                            return temp.getLoopResult();
                        }
                    }
                    throw new ExecError(cp, "Wrong exit for block", "Got " + (Object)((Object)temp.getLevel()) + ", need " + (Object)((Object)Return.LEVEL.BREAK));
                }
            }
            if (stream != null) {
                res = stream.exec(cp, it);
            }
            return new Result_Obj(res, true);
        }
    }

    private Result_Obj tee(CurProc cp) {
        Call stream = cp.getStream();
        this.iProcTeeBlock(cp);
        I_Object res = this;
        if (stream != null) {
            res = stream.exec(cp, this);
        }
        return new Result_Obj(res, true);
    }

    private JMo_List types() {
        String[] types = this.getTypes();
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(new Str(s));
            ++n2;
        }
        return new JMo_List(list);
    }

    private void iCheckParIsVar(CurProc cp, I_Object par, boolean parameter) {
        if (!(par instanceof Var)) {
            String so = parameter ? "Parameter" : "Object";
            throw new ParseError(cp, "Wrong " + so + "-Type", "Got " + par.getTypeName() + "(" + par.toDebug(cp) + "), expected: Var");
        }
    }
}

