/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type.datetime;

import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.form.FormDateTime;
import de.mn77.base.data.type.A_DataType;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class MDateTime
extends A_DataType<I_DateTime>
implements I_DateTime {
    private final I_Date date;
    private final I_Time time;

    public MDateTime() {
        this.date = new MDate();
        this.time = new MTime();
    }

    public MDateTime(I_Date date, I_Time time) {
        Err.ifNull(date, time);
        this.date = date;
        this.time = time;
    }

    public MDateTime(Calendar c) {
        Err.ifNull(c);
        this.date = new MDate(c);
        this.time = new MTime(c);
    }

    public MDateTime(long milliSec) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(milliSec);
        this.date = new MDate(c);
        this.time = new MTime(c);
    }

    public MDateTime(String s) {
        Err.ifEmpty(s);
        s = s.trim();
        try {
            if (s.matches("[0-3][0-9].[0-1][0-9].[1-2][0-9][0-9][0-9] [0-2][0-9]:[0-5][0-9]")) {
                this.date = new MDate(FilterText.cut(1, 10, s));
                this.time = new MTime(FilterText.cut(12, 5, s));
                return;
            }
            if (s.matches("[0-3][0-9].[0-1][0-9].[1-2][0-9][0-9][0-9] [0-2][0-9]:[0-5][0-9]:[0-5][0-9]")) {
                this.date = new MDate(FilterText.cut(1, 10, s));
                this.time = new MTime(FilterText.cut(12, 8, s));
                return;
            }
            if (s.matches("[1-2][0-9][0-9][0-9].[0-1][0-9].[0-3][0-9][ _][0-2][0-9][:\\.\\-][0-5][0-9][:\\.\\-][0-5][0-9]")) {
                this.date = new MDate(FilterText.cut(1, 10, s));
                this.time = new MTime(FilterText.cut(12, 8, s));
                return;
            }
            if (s.matches("[1-2][0-9][0-9][0-9][0-1][0-9][0-3][0-9][0-2][0-9][0-5][0-9][0-5][0-9]")) {
                this.date = new MDate(String.valueOf(FilterText.cut(1, 4, s)) + "-" + FilterText.cut(5, 2, s) + "-" + FilterText.cut(7, 2, s));
                this.time = new MTime(String.valueOf(FilterText.cut(9, 2, s)) + ":" + FilterText.cut(11, 2, s) + ":" + FilterText.cut(13, 2, s));
                return;
            }
            throw Err.invalid("Unknown format!", s);
        }
        catch (Err_Runtime f) {
            throw f;
        }
        catch (Exception e) {
            throw Err.invalid("Invalid String!");
        }
    }

    @Override
    public I_Time getTime() {
        return this.time;
    }

    @Override
    public int getHours() {
        return this.time.getHours();
    }

    @Override
    public int getMinutes() {
        return this.time.getMinutes();
    }

    @Override
    public int getSeconds() {
        return this.time.getSeconds();
    }

    @Override
    public I_Date getDate() {
        return this.date;
    }

    @Override
    public int getYear() {
        return this.date.getYear();
    }

    @Override
    public int getMonth() {
        return this.date.getMonth();
    }

    @Override
    public int getDay() {
        return this.date.getDay();
    }

    @Override
    public int diffHours(I_DateTime to) {
        long current = Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), 0);
        long other = Lib_DateTime.toMilliSec(to.getYear(), to.getMonth(), to.getDay(), to.getHours(), to.getMinutes(), to.getSeconds(), 0);
        long diff_ms = other - current;
        return (int)(diff_ms / 1000L / 3600L);
    }

    @Override
    public boolean isGreater(I_DateTime than) {
        long other;
        long current = Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), 0);
        long diff_ms = current - (other = Lib_DateTime.toMilliSec(than.getYear(), than.getMonth(), than.getDay(), than.getHours(), than.getMinutes(), than.getSeconds(), 0));
        return diff_ms > 0L;
    }

    @Override
    public String toString() {
        return FormDateTime.toText(this);
    }

    @Override
    public String toString(Object ... format) {
        return FormDateTime.toText(this, format);
    }

    @Override
    public String toStringIT() {
        return FormDateTime.toTextIT(this);
    }

    @Override
    public String toStringFileSys() {
        return FormDateTime.zuTextDS(this);
    }

    @Override
    public boolean isEqual(I_DateTime dateTime) {
        return this.date.isEqual(dateTime.getDate()) && this.time.isEqual(dateTime.getTime());
    }

    @Override
    public I_DateTime getAddDays(int days) {
        long current = Lib_DateTime.addDays(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), 0, days);
        return new MDateTime(current);
    }

    @Override
    public I_DateTime getAddHours(int hours) {
        long current = Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), 0);
        return new MDateTime(current += (long)hours * 60L * 60L * 1000L);
    }

    @Override
    public I_DateTime getAddMinutes(int minutes) {
        long current = Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), 0);
        return new MDateTime(current += (long)minutes * 60L * 1000L);
    }
}

