/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.set;

import de.mn77.base.data.struct.A_ListSet;
import de.mn77.base.data.struct.set.I_Set;
import de.mn77.base.error.Err;
import java.util.Collection;

public class MSet<T>
extends A_ListSet<T>
implements I_Set<T> {
    public MSet() {
    }

    public MSet(Collection<T> objects) {
        this.addAll(objects);
    }

    @Override
    public Integer searchPosition(T object) {
        int pos = 0;
        while (pos < this.data.size()) {
            if (object.equals(this.data.get(pos))) {
                return pos + 1;
            }
            ++pos;
        }
        return null;
    }

    @Override
    public boolean add(T o) {
        Err.ifEqual(o, this);
        if (!this.isValid(o)) {
            Err.invalid("Object is already known", o);
            return false;
        }
        this.data.add(o);
        return true;
    }

    @Override
    public void insert(int pos, T object) {
        Err.ifOutOfBounds(1.0, this.data.size() + 1, pos);
        Err.ifEqual(object, this);
        if (!this.isValid(object)) {
            Err.invalid("Object is already known", object);
        }
        this.data.add(pos - 1, object);
    }

    @Override
    public boolean remove(Object object) {
        int pos = this.data.size();
        while (pos > 0) {
            if (this.get(pos).equals(object)) {
                this.remove(pos);
                return true;
            }
            --pos;
        }
        return false;
    }

    @Override
    public Integer replace(T object, T with) {
        if (!this.isValid(with)) {
            Err.invalid("Object is already known", with);
        }
        int pos = 1;
        while (pos <= this.data.size()) {
            if (this.get(pos).equals(object)) {
                this.set(pos, with);
                return pos;
            }
            ++pos;
        }
        return null;
    }

    @Override
    public void addIfUnknown(T o) {
        Err.ifEqual(o, this);
        if (this.isValid(o)) {
            this.data.add(o);
        }
    }

    @Override
    public void addIfUnknown(Collection<T> collection) {
        for (T object : collection) {
            this.addIfUnknown(object);
        }
    }

    @Override
    public I_Set<T> copy() {
        MSet<T> result = new MSet<T>();
        for (Object t : this) {
            result.add(t);
        }
        return result;
    }

    private boolean isValid(T t) {
        for (Object o : this.data) {
            if (!o.equals(t)) continue;
            return false;
        }
        return true;
    }
}

