/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.constant.position.H_POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.form.FormText;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;

public class Lib_StrFormat {
    private static final String REGEX = "^([1-9]+)?([!\\?]+)?([<>^])?([idcsb])?$";

    public static String format(CurProc cp, String s, I_Object o) {
        String sFieldLen;
        int len = s.length();
        String os = Lib_Convert.getStringValue(cp, o);
        if (len == 2) {
            return os;
        }
        if (!(s = s.substring(1, len - 1)).matches(REGEX)) {
            Err.todo(REGEX, s);
        }
        int field_len = (sFieldLen = s.replaceFirst(REGEX, "$1")) == "" ? 0 : Integer.parseInt(sFieldLen);
        String sOverflow = s.replaceFirst(REGEX, "$2");
        boolean cutOverflow = sOverflow.length() == 0 ? false : sOverflow.equals("!");
        String sAlign = s.replaceFirst(REGEX, "$3");
        H_POSITION.H align = sAlign.equals("<") ? POSITION_H.LEFT : (sAlign.equals(">") ? POSITION_H.RIGHT : (sAlign.equals("^") ? POSITION_H.CENTER : null));
        String sType = s.replaceFirst(REGEX, "$4");
        Character type = Character.valueOf((char)(sType.length() > 0 ? sType.charAt(0) : (o instanceof Bool ? 98 : (o instanceof Char ? 99 : (o instanceof Dec ? 100 : (o instanceof Int ? 105 : (o instanceof JMo_Byte ? 105 : (o instanceof JMo_Float ? 100 : (o instanceof JMo_Long ? 105 : (o instanceof JMo_Short ? 105 : 115))))))))));
        switch (type.charValue()) {
            case 's': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                return FormText.width(field_len, ' ', os, align, cutOverflow);
            }
            case 'c': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                os = "" + Lib_Convert.getCharValue(cp, o);
                return FormText.width(field_len, ' ', os, align, cutOverflow);
            }
            case 'i': {
                if (align == null) {
                    align = POSITION_H.RIGHT;
                }
                os = "" + Lib_Convert.getIntValue(cp, o);
                return FormText.width(field_len, ' ', os, align, cutOverflow);
            }
            case 'd': {
                if (align == null) {
                    align = POSITION_H.RIGHT;
                }
                os = "" + Lib_Convert.getDoubleValue(cp, o);
                return FormText.width(field_len, ' ', os, align, cutOverflow);
            }
            case 'b': {
                if (align == null) {
                    align = POSITION_H.LEFT;
                }
                os = "" + Lib_Convert.getBoolValue(cp, o);
                return FormText.width(field_len, ' ', os, align, cutOverflow);
            }
        }
        throw Err.todo(s, os, type);
    }

    public static final Group2<Boolean, String> getNext(String s, int offset) {
        boolean formatOpen = false;
        int pos = offset;
        while (pos < s.length()) {
            char c = s.charAt(pos);
            if (c == '\\') {
                ++pos;
            } else {
                if (c == '{') {
                    if (pos == offset) {
                        formatOpen = true;
                    } else {
                        return new Group2<Boolean, String>(false, s.substring(offset, pos));
                    }
                }
                if (c == '}' && formatOpen) {
                    return new Group2<Boolean, String>(true, s.substring(offset, pos + 1));
                }
            }
            ++pos;
        }
        return new Group2<Boolean, String>(formatOpen, s.substring(offset));
    }
}

