/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Java;

public class Java2JMo
extends A_Object {
    private String className;
    private final Call classNameCall;
    private final Call[] constructorPars;
    private Object instance = null;
    private Class<?> instance_class = null;

    public Java2JMo(Call classNameCall, Call[] pars, DebugInfo debugInfo) {
        this.className = null;
        this.classNameCall = classNameCall;
        this.constructorPars = pars;
    }

    public Java2JMo(String name, Call[] pars, DebugInfo debugInfo) {
        this.className = name;
        this.classNameCall = null;
        this.constructorPars = pars;
    }

    @Override
    public void init(CurProc cp) {
        if (this.className == null && this.classNameCall != null) {
            I_Object oName = this.classNameCall.exec(cp, null);
            if (!(oName instanceof Str)) {
                throw new ExecError(cp, "First Parameter has a wrong Type!", "Need a Str with the Java-Class-Name");
            }
            this.className = Lib_Convert.getStringValue(cp, oName);
        }
        if (this.className.startsWith("JMo_")) {
            throw new ExecError(cp, "It's not allowed to create JMo-Objects via Java-Class!", this.className);
        }
        this.instance_class = this.searchClass(cp);
        this.instance = this.getInstance(cp, this.instance_class);
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        Method[] methods;
        I_Object[] pars = cp.parsFlex(null, 0, Integer.MAX_VALUE, false);
        int parsLen = pars.length;
        Method[] methodArray = methods = this.instance_class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(cp.gMethod()) && method.getParameterCount() == parsLen && this.iTestPars(method.getParameters(), pars)) {
                Object[] invokePars = this.iJMoToJava(pars, parsLen);
                try {
                    Object result = method.invoke(this.instance, invokePars);
                    I_Object resultJMo = Lib_Java.javaToJmo(result);
                    return new Result_Obj(resultJMo, false);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    Err.show(e, true);
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String toDebug(CurProc cp) {
        return null;
    }

    @Override
    public String toString() {
        return "Java(\"" + this.className + "\")";
    }

    private Object getInstance(CurProc cp, Class<?> cl) {
        if (this.constructorPars == null || this.constructorPars.length == 0) {
            try {
                return cl.newInstance();
            }
            catch (InstantiationException e) {
                Err.show(e, true);
            }
            catch (IllegalAccessException e) {
                String message = e.getMessage().replace("Class " + Java2JMo.class.getName(), "You");
                throw new ExecError(cp, "Illegal Access", message);
            }
        }
        throw Err.invalid(this.className, this.constructorPars);
    }

    private Object[] iJMoToJava(I_Object[] pars, int len) {
        Object[] result = new Object[len];
        int p = 0;
        while (p < len) {
            result[p] = Lib_Java.jmoToJava(pars[p]);
            ++p;
        }
        return result;
    }

    private boolean iTestPar(Parameter parameter, I_Object object) {
        Class<?> pClass = parameter.getType();
        int parModif = parameter.getModifiers();
        Class<?> oClass = object.getClass();
        if (parModif != 0) {
            Err.todo(pClass, parModif, oClass);
        }
        return Lib_Java.comparable(pClass, oClass);
    }

    private boolean iTestPars(Parameter[] parameters, I_Object[] pars) {
        int pn = 0;
        while (pn < parameters.length) {
            if (!this.iTestPar(parameters[pn], pars[pn])) {
                return false;
            }
            ++pn;
        }
        return true;
    }

    private Class<?> searchClass(CurProc cp) {
        char c1 = this.className.charAt(0);
        Class<I_Object> result = null;
        if (c1 >= 'a' && c1 <= 'z') {
            try {
                result = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new ExecError(cp, "Java-Class not found!", this.className);
            }
        } else {
            Package[] packages;
            Package[] packageArray = packages = Package.getPackages();
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                Package p = packageArray[n2];
                String test = String.valueOf(p.getName()) + "." + this.className;
                try {
                    result = Class.forName(test);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ++n2;
                }
            }
        }
        if (result.isAssignableFrom(I_Object.class)) {
            throw new ExecError(cp, "It's not allowed to create JMo-Objects via Java-Class!", this.className);
        }
        return result;
    }
}

