/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.pseudo;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.struct.ObjectManager;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;

public class ObjectSearch
extends A_Object {
    private final HintManager hm;
    private final String search;
    private final boolean constructors;

    public ObjectSearch(HintManager hm, String s, boolean constructors) {
        this.hm = hm;
        this.search = s;
        this.constructors = constructors;
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        JMo_List result = null;
        switch (cp.gMethod()) {
            case "list": {
                result = this.iGetList(cp);
                break;
            }
            default: {
                return null;
            }
        }
        return new Result_Obj(result, false);
    }

    @Override
    public Result_Obj print(CurProc cp, boolean newline) {
        this.iShow(cp);
        return new Result_Obj(this, false);
    }

    @Override
    public I_Object standaloneExec(CurProc cp) {
        this.iShow(cp);
        return Nil.NIL;
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "\"" + this.search + "\"?";
    }

    private JMo_List iGetList(CurProc cp) {
        cp.pars();
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        ArrayList<String> objs = this.iGetStrings(cp);
        for (String s : objs) {
            al.add(new Str(s));
        }
        return new JMo_List(al);
    }

    private ArrayList<String> iGetObjects() {
        ArrayList<String> objs = ObjectManager.search(this.hm, this.search);
        Collections.sort(objs);
        return objs;
    }

    private ArrayList<String> iGetPars(CurProc cp) {
        Class<? extends I_Object> cl = ObjectManager.getClass(this.search);
        if (cl == null) {
            throw new ExecError(cp, "Unknown Object-Type", this.search);
        }
        Constructor<?>[] con = cl.getConstructors();
        ArrayList<String> al = new ArrayList<String>();
        Constructor<?>[] constructorArray = con;
        int n = con.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> co = constructorArray[n2];
            Class<?>[] pars = co.getParameterTypes();
            String pars2 = Lib_Convert.typelistToText(pars);
            al.add(String.valueOf(this.search) + pars2);
            ++n2;
        }
        return al;
    }

    private String iGetString(CurProc cp) {
        ArrayList<String> als = this.iGetStrings(cp);
        CharSequence[] sa = als.toArray(new String[als.size()]);
        return String.join((CharSequence)"\n", sa);
    }

    private ArrayList<String> iGetStrings(CurProc cp) {
        return this.constructors ? this.iGetPars(cp) : this.iGetObjects();
    }

    private void iShow(CurProc cp) {
        String res = this.iGetString(cp);
        Lib_Output.out(cp.gApp(), res, true);
    }
}

