/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.filesys;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.Lib_FileSys;
import java.io.File;
import java.util.ArrayList;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.filesys.A_FileSys;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;

public class JMo_Dir
extends A_FileSys
implements I_Object {
    private Call par;
    private File file = null;

    public JMo_Dir(Call par) {
        Err.ifNull(par);
        this.par = par;
    }

    public JMo_Dir(File f) {
        Err.ifNull(f);
        this.file = f;
    }

    @Override
    public void init2(CurProc cp) {
        if (this.par != null) {
            I_Object filename = this.par.exec(cp, null);
            if (!((filename = Lib_Convert.getValue(cp, filename)) instanceof Str)) {
                throw Err.invalid(filename.toDebug(cp));
            }
            String sDir = ((Str)filename).gValue();
            this.file = new File(sDir);
        }
    }

    @Override
    public Result_Obj call3(CurProc cp) {
        switch (cp.gMethod()) {
            case "list": {
                return JMo_Dir.stdResult(this.list(cp));
            }
            case "files": {
                return JMo_Dir.stdResult(this.files(cp));
            }
            case "dirs": {
                return JMo_Dir.stdResult(this.dirs(cp));
            }
            case "makeDir": {
                return JMo_Dir.stdResult(this.makeDir(cp));
            }
        }
        return null;
    }

    @Override
    public String toDebug(CurProc cp) {
        String p = Lib_Output.toDebug(cp, this.par);
        if (p.length() != 0) {
            p = "(" + p + ")";
        }
        return "Dir" + p;
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    protected File pFile() {
        return this.file;
    }

    @Override
    protected I_Object rename(CurProc cp) {
        Err.todo(cp);
        return null;
    }

    private JMo_List dirs(CurProc cp) {
        cp.pars();
        return this.iDirList(false, true);
    }

    private JMo_List files(CurProc cp) {
        cp.pars();
        return this.iDirList(true, false);
    }

    private JMo_List iDirList(boolean files, boolean dirs) {
        File[] dirContent;
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        File[] fileArray = dirContent = this.file.listFiles();
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            boolean isf = f.isFile();
            if (isf && files) {
                al.add(new JMo_File(f));
            }
            if (!isf && dirs) {
                al.add(new JMo_Dir(f));
            }
            ++n2;
        }
        return new JMo_List(al);
    }

    private JMo_List list(CurProc cp) {
        cp.pars();
        return this.iDirList(true, true);
    }

    private JMo_Dir makeDir(CurProc cp) {
        Str par = (Str)cp.pars(this, Str.class)[0];
        String newDirName = par.gValue();
        if (newDirName.contains(Sys.getSeperatorDir())) {
            throw new ExecError(cp, "Can't create Directory", "No target-path allowed");
        }
        newDirName = String.valueOf(this.file.getParent()) + Sys.getSeperatorDir() + newDirName;
        try {
            Lib_FileSys.createPathStructure(newDirName);
        }
        catch (Err_FileSys e) {
            throw new ExecError(cp, "Can't create Directory", newDirName);
        }
        return new JMo_Dir(new File(newDirName));
    }
}

