/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.error.Err;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;

public class JMo_Float
extends A_Number
implements I_Decimal {
    private final float value;

    public JMo_Float(float val) {
        this.value = (float)Lib_Math.normalize(val, 10);
    }

    @Override
    public Result_Obj call4(CurProc cp, String method) {
        String string = method;
        string.hashCode();
        return null;
    }

    @Override
    public int compareTo(I_Object o) {
        if (o instanceof JMo_Float) {
            return new Float(this.value).compareTo(((JMo_Float)o).gValue());
        }
        return super.compareTo(o);
    }

    @Override
    public I_Atomic convertTo(CurProc cp, ATOMIC to) {
        return Lib_AtomConv.convert(cp, ATOMIC.FLOAT, to, this, this.gValue());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JMo_Float && ((JMo_Float)obj).gValue().floatValue() == this.value;
    }

    @Override
    public Float gValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public String toDebug(CurProc cp) {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CurProc cp, COMPARE m) {
        I_Object o = cp.parsExt(this, new Class[][]{{Bool.class, Char.class, Int.class, JMo_Float.class}})[0];
        Double par = Lib_Convert.getDoubleValue(cp, o);
        if (m == COMPARE.G) {
            return Bool.getObject((double)this.value > par);
        }
        if (m == COMPARE.L) {
            return Bool.getObject((double)this.value < par);
        }
        if (m == COMPARE.GE) {
            return Bool.getObject((double)this.value >= par);
        }
        if (m == COMPARE.LE) {
            return Bool.getObject((double)this.value <= par);
        }
        if (m == COMPARE.E) {
            return Bool.getObject((double)this.value == par);
        }
        if (m == COMPARE.NE) {
            return Bool.getObject((double)this.value != par);
        }
        throw Err.todo(new Object[]{cp, m});
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP0 op) {
        switch (op) {
            case INC: {
                return new JMo_Float(this.value + 1.0f);
            }
            case DEC: {
                return new JMo_Float(this.value - 1.0f);
            }
            case NEG: {
                return new JMo_Float(-this.value);
            }
            case ABS: {
                return new JMo_Float(Math.abs(this.value));
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op));
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP01 op, I_Object[] pars) {
        if (pars.length == 0) {
            switch (op) {
                case POW: {
                    return new JMo_Float(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
                case SQRR: {
                    return new Int((int)Math.round(Math.sqrt(this.value)));
                }
            }
        } else {
            A_Number parn = (A_Number)cp.parType(pars[0], (Class<?>)A_Number.class);
            double par = Lib_Convert.getDoubleValue(cp, parn);
            switch (op) {
                case POW: {
                    return new Dec(Math.pow(this.value, par));
                }
                case SQR: {
                    return new Dec(Math.exp(Math.log(this.value) / par));
                }
                case SQRR: {
                    return new Int((int)Math.round(Math.exp(Math.log(this.value) / par)));
                }
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + pars.length);
    }

    @Override
    protected A_Number number_op(CurProc cp, A_Number.NOP1 op, A_Number parn) {
        double val = this.value;
        double par = Lib_Convert.getDoubleValue(cp, parn);
        switch (op) {
            case ADD: {
                return new Dec(val + par);
            }
            case SUB: {
                return new Dec(val - par);
            }
            case MUL: {
                return new Dec(val * par);
            }
            case DIV: {
                if (par == 0.0) {
                    throw new ExecError(cp, "Division by zero", val + "/" + par);
                }
                return new Dec(val / par);
            }
            case DIVR: {
                if (par == 0.0) {
                    throw new ExecError(cp, "Division by zero", val + "/" + par);
                }
                return new Int((int)Math.round(val / par));
            }
            case MOD: {
                return new Dec(val % par);
            }
            case AND: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) & Double.doubleToRawLongBits(par)));
            }
            case OR: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) | Double.doubleToRawLongBits(par)));
            }
            case XOR: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) ^ Double.doubleToRawLongBits(par)));
            }
            case SHL: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) << (int)Double.doubleToRawLongBits(par)));
            }
            case SHR: {
                return new Dec(Double.longBitsToDouble(Double.doubleToRawLongBits(this.value) >> (int)Double.doubleToRawLongBits(par)));
            }
            case LOG: {
                return new Dec(Math.log(this.value) / Math.log(par));
            }
            case LOGR: {
                return new Int((int)Math.round(Math.log(this.value) / Math.log(par)));
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", (Object)((Object)op) + " " + parn.getClass().getSimpleName());
    }

    @Override
    protected Str number_opStr(CurProc cp, A_Number.NOP1 op, A_Atomic p) {
        String val = "" + this.value;
        String par = Lib_Convert.getStringValue(cp, p);
        switch (op) {
            case ADD: {
                return new Str(String.valueOf(val) + par);
            }
            case MUL: {
                throw new ExecError(cp, "Wrong Type to multiply a Char or Str", "Got " + this.getClass().getSimpleName() + ", please use Int");
            }
        }
        throw new ExecError(cp, "Unknown Type or Function", (Object)((Object)op) + " " + p.getClass().getSimpleName());
    }
}

