/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.constant.position.H_POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.form.FormText;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.Nil;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.list.JMo_List;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Result_Obj;
import org.jmo_lang.struct.runtime.CurProc;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Output;

public class JMo_Table
extends A_Object
implements I_Object {
    private I_Table<I_Object> tab;
    private Call width;

    public JMo_Table(Call width) {
        this.width = width;
    }

    public JMo_Table(I_Table<I_Object> init_tab) {
        this.tab = init_tab;
    }

    @Override
    public Result_Obj call2(CurProc cp) {
        if (this.tab == null) {
            int w = ((Int)this.width.exec(cp, null)).gValue();
            this.tab = new MTable<I_Object>(w);
        }
        switch (cp.gMethod()) {
            case "get": {
                return JMo_Table.stdResult(this.get(cp));
            }
            case "set": {
                return JMo_Table.stdResult(this.set(cp));
            }
            case "+": 
            case "add": {
                return JMo_Table.stdResult(this.add(cp));
            }
            case "print": {
                return JMo_Table.stdResult(this.print(cp));
            }
            case "each": {
                return this.each(cp);
            }
            case "search": {
                return JMo_Table.stdResult(this.search(cp));
            }
            case "searchFirst": {
                return JMo_Table.stdResult(this.searchFirst(cp));
            }
        }
        return null;
    }

    public I_Table<I_Object> getInternalObject() {
        return this.tab;
    }

    @Override
    public String toDebug(CurProc cp) {
        return this.toText(cp, true);
    }

    @Override
    public String toString() {
        return this.toText(null, false);
    }

    private String toText(CurProc cp, boolean debug) {
        if (this.tab == null) {
            return "Table";
        }
        boolean[][] right = new boolean[this.tab.getWidth()][this.tab.size()];
        MTable<String> otab = new MTable<String>(this.tab.getWidth());
        int y = 0;
        for (I_Sequence i_Sequence : this.tab) {
            String[] sa = new String[i_Sequence.size()];
            int x = 0;
            while (x < sa.length) {
                I_Object o = (I_Object)i_Sequence.get(x + 1);
                Class<?> t = o.getClass();
                right[x][y] = t == Int.class || t == Dec.class;
                sa[x] = debug ? o.toDebug(cp) : o.toString();
                ++x;
            }
            otab.addItems(sa);
            ++y;
        }
        int[] nArray = new int[this.tab.getWidth()];
        int spalte = 1;
        while (spalte <= this.tab.getWidth()) {
            int max = 0;
            int zeile = 1;
            while (zeile <= this.tab.size()) {
                max = Math.max(max, ((String)otab.get(spalte, zeile)).length());
                ++zeile;
            }
            nArray[spalte - 1] = max;
            ++spalte;
        }
        StringBuilder sb = new StringBuilder();
        y = 0;
        for (I_Sequence zeile : otab) {
            int spalte2 = 1;
            while (spalte2 <= this.tab.getWidth()) {
                String o = (String)zeile.get(spalte2);
                H_POSITION.H pos = right[spalte2 - 1][y] ? POSITION_H.RIGHT : POSITION_H.LEFT;
                sb.append(FormText.width(nArray[spalte2 - 1], ' ', o, pos, false));
                if (spalte2 != this.tab.getWidth()) {
                    sb.append('|');
                }
                ++spalte2;
            }
            if (++y >= this.tab.size()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private JMo_Table add(CurProc cp) {
        I_Object[] pars = cp.parsFlex(this, this.tab.getWidth(), this.tab.getWidth(), false);
        this.tab.addItems((I_Object[])pars);
        return this;
    }

    private Result_Obj each(CurProc cp) {
        cp.parsWithBlock(this, new Class[0]);
        Call stream = cp.gStream();
        Block block = cp.gCallBlock();
        if (stream == null && block == null) {
            Err.impossible("No block, no stream, what should I do?");
        }
        I_Object res = this;
        I_Object last = null;
        block5: for (I_Sequence i_Sequence : this.tab) {
            I_Object itO;
            last = itO = this.rotToList(i_Sequence);
            if (block != null) {
                try {
                    res = block.exec(cp, itO);
                }
                catch (ReturnException e) {
                    Return temp = e.get();
                    switch (temp.getLevel()) {
                        case CONTINUE: {
                            res = temp.getResult();
                            continue block5;
                        }
                        default: {
                            return temp.getLoopResult();
                        }
                    }
                }
            }
            if (stream == null || block != null) continue;
            res = stream.exec(cp, itO);
        }
        if (stream != null && block != null) {
            res = stream.exec(cp, last);
        }
        return new Result_Obj(res, true);
    }

    private I_Object get(CurProc cp) {
        I_Object[] pars = cp.parsFlex(this, 1, 2, false);
        if (pars.length == 1) {
            I_Object y = cp.parType(pars[0], (Class<?>)Int.class);
            int iy = Lib_Convert.getIntValue(cp, y);
            return this.rotToList((I_Sequence)this.tab.get(iy));
        }
        int x = ((Int)cp.parType(pars[0], (Class<?>)Int.class)).gValue();
        int y = ((Int)cp.parType(pars[1], (Class<?>)Int.class)).gValue();
        return this.tab.get(x, y);
    }

    private JMo_Table print(CurProc cp) {
        cp.pars();
        Lib_Output.out(cp.gApp(), this.toString(), false);
        return this;
    }

    private I_Object rotToList(I_Sequence<I_Object> it) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (I_Object item : it) {
            al.add(item);
        }
        return new JMo_List(al);
    }

    private JMo_Table search(CurProc cp) {
        I_Atomic searcho = (I_Atomic)cp.pars(this, I_Atomic.class)[0];
        String search = Lib_Convert.getStringValue(cp, searcho);
        MTable<I_Object> res = new MTable<I_Object>(this.tab.getWidth());
        int y = 1;
        while (y <= this.tab.size()) {
            int x = 1;
            while (x <= this.tab.getWidth()) {
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cp, o);
                if (s.equals(search)) {
                    I_Sequence row = (I_Sequence)this.tab.get(y);
                    res.add(row);
                }
                ++x;
            }
            ++y;
        }
        return new JMo_Table(res);
    }

    private I_Object searchFirst(CurProc cp) {
        I_Atomic searcho = (I_Atomic)cp.pars(this, I_Atomic.class)[0];
        String search = Lib_Convert.getStringValue(cp, searcho);
        int y = 1;
        while (y <= this.tab.size()) {
            int x = 1;
            while (x <= this.tab.getWidth()) {
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cp, o);
                if (s.equals(search)) {
                    I_Sequence row = (I_Sequence)this.tab.get(y);
                    ArrayList<I_Object> row2 = new ArrayList<I_Object>();
                    for (I_Object item : row) {
                        row2.add(item);
                    }
                    return new JMo_List(row2);
                }
                ++x;
            }
            ++y;
        }
        return Nil.NIL;
    }

    private JMo_Table set(CurProc cp) {
        I_Object[] xyo = cp.pars(this, Int.class, Int.class, I_Object.class);
        int x = Lib_Convert.getIntValue(cp, xyo[0]);
        int y = Lib_Convert.getIntValue(cp, xyo[1]);
        this.tab.set(x, y, xyo[2]);
        return this;
    }
}

