/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.I_File;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Lib_FileSys {
    public static String getSuffix(File file) {
        String name = file.getName();
        String suffix = name.replaceFirst("^.*\\.(.*)$", "$1");
        if (suffix.length() > 10 || name.equals(suffix)) {
            return "";
        }
        return suffix;
    }

    public static Process start(File f) throws Err_FileSys {
        if (Sys.isWindows()) {
            return Lib_FileSys.startWindows(f.getAbsolutePath());
        }
        if (Sys.isLinux()) {
            return Lib_FileSys.startLinux(f.getAbsolutePath());
        }
        throw Err.todo("Unknown Operating-System", Sys.getOsName(), Sys.getOsVersion());
    }

    private static Process startWindows(String path) throws Err_FileSys {
        try {
            return new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", path).start();
        }
        catch (IOException e) {
            throw Err.newFileSys("Starting failed", e, path);
        }
    }

    private static Process startLinux(String path) throws Err_FileSys {
        try {
            String[] pars = null;
            pars = new String[]{"xdg-open", path};
            return new ProcessBuilder(pars).start();
        }
        catch (IOException e) {
            throw Err.newFileSys("Starting failed", e, path);
        }
    }

    public static boolean rename(File from, File to) throws Err_FileSys {
        Err.fsIfMissing(from);
        Err.fsIfExist(to);
        return from.renameTo(to);
    }

    public static void copyFile(File from, File to) throws Err_FileSys {
        if (from.isDirectory()) {
            Err.forbidden("Can't copy a directory", from, to);
        }
        Err.fsIfMissing(from);
        Err.fsIfExist(to);
        Lib_FileSys.iCopyFile(from, to);
    }

    public static void move(File from, File to) throws Err_FileSys {
        boolean erg = from.renameTo(to);
        if (!erg) {
            throw Err.newFileSys("Moving file failed", from, to);
        }
    }

    public static void createPathStructure(String path) throws Err_FileSys {
        String dirSep = Sys.getSeperatorDir();
        String[] elements = path.split(dirSep);
        MOut.debug(elements, dirSep);
        String current = Sys.isWindows() ? "" : dirSep;
        boolean first = true;
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.length() != 0) {
                if (first) {
                    first = false;
                } else {
                    current = String.valueOf(current) + dirSep;
                }
                current = String.valueOf(current) + element;
                File f = new File(current);
                if (!f.exists() && !f.mkdir()) {
                    throw Err.newFileSys("Couldn't create Directory!", current);
                }
            }
            ++n2;
        }
    }

    public static byte[] read(I_File file) throws Err_FileSys {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file.getFile(), "r");
            Vector<Byte> v = new Vector<Byte>();
            while (raf.getFilePointer() < raf.length()) {
                v.add(raf.readByte());
            }
            v.toArray(new Byte[0]);
            byte[] ba = new byte[v.size()];
            int p = 0;
            while (p < v.size()) {
                ba[p] = (Byte)v.get(p);
                ++p;
            }
            byte[] byArray = ba;
            return byArray;
        }
        catch (Exception err) {
            throw Err.fsAccess("Read-Error", err);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e, false);
            }
        }
    }

    public static String read(I_File file, String charset) throws Err_FileSys, UnsupportedEncodingException {
        byte[] z = Lib_FileSys.read(file);
        return new String(z, charset);
    }

    private static void iCopyFile(File from, File to) throws Err_FileSys {
        byte[] buffer = new byte[8192];
        int read = 0;
        RandomAccessFile raf_source = null;
        RandomAccessFile raf_target = null;
        try {
            try {
                raf_source = new RandomAccessFile(from, "r");
                raf_target = new RandomAccessFile(to, "rw");
                raf_target.setLength(raf_source.length());
                while ((read = raf_source.read(buffer)) > 0) {
                    raf_target.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                throw Err.wrap(e, "Copy-Error!");
            }
        }
        finally {
            block28: {
                try {
                    try {
                        raf_source.close();
                    }
                    catch (IOException e) {
                        MOut.error(e, "Couldn't close source-file!");
                        try {
                            raf_target.close();
                        }
                        catch (IOException e2) {
                            MOut.error(e2, "Couln't close target-file!");
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        raf_target.close();
                    }
                    catch (IOException e) {
                        MOut.error(e, "Couln't close target-file!");
                    }
                    throw throwable;
                }
                try {
                    raf_target.close();
                }
                catch (IOException e) {
                    MOut.error(e, "Couln't close target-file!");
                }
            }
        }
    }
}

