/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys;

import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.form.FormText;
import de.mn77.base.error.Err;
import de.mn77.base.event.Procedure;
import de.mn77.base.sys.MOut;
import java.lang.management.ManagementFactory;
import java.util.Enumeration;
import java.util.Properties;

public class Sys {
    public static void main(String[] args) {
        try {
            MOut.text(Sys.getProcessID(), "");
            Properties props = System.getProperties();
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object val = props.get(key);
                MOut.text(String.valueOf(FormText.width(30, "" + key, false)) + val);
            }
        }
        catch (Throwable t) {
            Err.show(t, false);
        }
    }

    public static String getPathTemp() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getPathHome() {
        return System.getProperty("user.home");
    }

    public static String getArchitectur() {
        return System.getProperty("os.arch");
    }

    public static String getArchitecturModel() {
        return System.getProperty("sun.arch.data.model");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getFontEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getLand() {
        return System.getProperty("user.country");
    }

    public static String getLanguage() {
        return System.getProperty("user.language");
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getDesktop() {
        return System.getProperty("sun.desktop");
    }

    public static String getSeperatorDir() {
        return System.getProperty("file.separator");
    }

    public static String getSeparatorPath() {
        return System.getProperty("path.separator");
    }

    public static String getSeparatorLine() {
        return System.getProperty("line.separator");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static long getProcessUptimeMSek() {
        return ManagementFactory.getRuntimeMXBean().getUptime();
    }

    public static Integer getProcessID() {
        String s = ManagementFactory.getRuntimeMXBean().getName();
        MOut.debug(s);
        if (s == null) {
            return null;
        }
        if (!s.matches("^([0-9]+).*$")) {
            s = "";
        }
        if ((s = s.replaceFirst("^([0-9]+).*$", "$1")).length() > 0) {
            return Integer.parseInt(s);
        }
        return null;
    }

    public static boolean sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean sleepSeconds(int seconds) {
        return Sys.sleep(seconds * 1000);
    }

    public static boolean sleepMinutes(int minutes) {
        return Sys.sleep(minutes * 60 * 1000);
    }

    public static void eventEnd(final Procedure p) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                p.execute();
            }
        });
    }

    public static Thread[] getThreadsActive() {
        ThreadGroup start = Thread.currentThread().getThreadGroup();
        while (start.getParent() != null) {
            start = start.getParent();
        }
        Thread[] result = new Thread[start.activeCount()];
        start.enumerate(result, true);
        return result;
    }

    public static boolean isWindows() {
        String system = Sys.iToShortLowerCase(Sys.getOsName());
        return system.contains("windows") || system.contains("win");
    }

    public static boolean isLinux() {
        String system = Sys.iToShortLowerCase(Sys.getOsName());
        return system.equals("linux");
    }

    public static boolean isMac() {
        String system = Sys.iToShortLowerCase(Sys.getOsName());
        return system.contains("mac") || system.contains("darwin");
    }

    private static String iToShortLowerCase(String name) {
        return FilterText.removeChars(new char[]{' '}, name.toLowerCase());
    }
}

