/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table.type;

import de.mn77.base.data.group.Group1;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group3;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.type.A_TypTabelle;
import de.mn77.base.error.Err;

public class TypeTable3<TA, TB, TC>
extends A_TypTabelle<Group3<TA, TB, TC>, I_List<?>> {
    private final I_List<TA> col1 = new MList<TA>();
    private final I_List<TB> col2 = new MList<TB>();
    private final I_List<TC> col3 = new MList<TC>();

    public TypeTable3(Class<TA> class1, Class<TB> class2, Class<TC> class3) {
        super(class1, class2, class3);
    }

    @Override
    public int getWidth() {
        return 3;
    }

    public I_List<TA> getCol1() {
        return (I_List)this.col1.copy();
    }

    public I_List<TB> getCol2() {
        return (I_List)this.col2.copy();
    }

    public I_List<TC> getCol3() {
        return (I_List)this.col3.copy();
    }

    @Override
    public Group3<TA, TB, TC> getRow(int row) {
        return new Group3(this.col1.get(row), this.col2.get(row), this.col3.get(row));
    }

    @Override
    public I_List<?> getCol(int col) {
        if (col == 1) {
            return this.getCol1();
        }
        if (col == 2) {
            return this.getCol2();
        }
        if (col == 3) {
            return this.getCol3();
        }
        throw Err.invalid(col);
    }

    @Override
    public I_List<?> getColDirect(int col) {
        if (col == 1) {
            return this.col1;
        }
        if (col == 2) {
            return this.col2;
        }
        if (col == 3) {
            return this.col3;
        }
        throw Err.invalid(col);
    }

    @Override
    public <T> I_List<T> getCol(int col, Class<T> type) {
        if (col == 1) {
            return this.getCol1();
        }
        if (col == 2) {
            return this.getCol2();
        }
        if (col == 3) {
            return this.getCol3();
        }
        throw Err.invalid(col);
    }

    public boolean knows(TA obj_col1, TB obj_col2, TC obj_col3) {
        int p = 1;
        while (p <= this.size()) {
            Object g = this.getRow(p);
            if (((Group1)g).g1().equals(obj_col1) && ((Group2)g).g2().equals(obj_col2) && ((Group3)g).g3().equals(obj_col3)) {
                return true;
            }
            ++p;
        }
        return false;
    }

    @Override
    protected void pSet(int col, int row, Object object) {
        if (col == 1) {
            this.col1.set(row, object);
        }
        if (col == 2) {
            this.col2.set(row, object);
        }
        if (col == 3) {
            this.col3.set(row, object);
        }
    }

    @Override
    protected void pReplace(int row, Object[] objects) {
        this.col1.set(row, objects[0]);
        this.col2.set(row, objects[1]);
        this.col3.set(row, objects[2]);
    }

    @Override
    protected void pExchange(int row_a, int row_b) {
        this.col1.exchange(row_a, row_b);
        this.col2.exchange(row_a, row_b);
        this.col3.exchange(row_a, row_b);
    }

    @Override
    protected void pAdd(Object[] row) {
        this.col1.add(row[0]);
        this.col2.add(row[1]);
        this.col3.add(row[2]);
    }

    @Override
    protected void pInsert(int row, Object[] objects) {
        this.col1.insert(row, objects[0]);
        this.col2.insert(row, objects[1]);
        this.col3.insert(row, objects[2]);
    }

    @Override
    protected void pRemove(int row) {
        this.col1.remove(row);
        this.col2.remove(row);
        this.col3.remove(row);
    }
}

