/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table.type;

import de.mn77.base.data.group.Group1;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.type.A_TypTabelle;
import de.mn77.base.error.Err;

public class TypeTable2<TA, TB>
extends A_TypTabelle<Group2<TA, TB>, I_List<?>> {
    private final I_List<TA> column1 = new MList<TA>();
    private final I_List<TB> column2 = new MList<TB>();

    public TypeTable2(Class<TA> class1, Class<TB> class2) {
        super(class1, class2);
    }

    @Override
    public int getWidth() {
        return 2;
    }

    public I_List<TA> getCol1() {
        return (I_List)this.column1.copy();
    }

    public I_List<TB> getCol2() {
        return (I_List)this.column2.copy();
    }

    @Override
    public Group2<TA, TB> getRow(int row) {
        return new Group2(this.column1.get(row), this.column2.get(row));
    }

    @Override
    public I_List<?> getCol(int col) {
        if (col == 1) {
            return this.getCol1();
        }
        if (col == 2) {
            return this.getCol2();
        }
        throw Err.invalid(col);
    }

    @Override
    public I_List<?> getColDirect(int col) {
        if (col == 1) {
            return this.column1;
        }
        if (col == 2) {
            return this.column2;
        }
        throw Err.invalid(col);
    }

    @Override
    public <T> I_List<T> getCol(int col, Class<T> type) {
        if (col == 1) {
            return this.getCol1();
        }
        if (col == 2) {
            return this.getCol2();
        }
        throw Err.invalid(col);
    }

    public boolean knows(TA obj_col1, TB obj_col2) {
        int p = 1;
        while (p <= this.size()) {
            Object g = this.getRow(p);
            if (((Group1)g).g1().equals(obj_col1) && ((Group2)g).g2().equals(obj_col2)) {
                return true;
            }
            ++p;
        }
        return false;
    }

    @Override
    protected void pSet(int col, int row, Object object) {
        if (col == 1) {
            this.column1.set(row, object);
        }
        if (col == 2) {
            this.column2.set(row, object);
        }
    }

    @Override
    protected void pReplace(int row, Object[] objects) {
        this.column1.set(row, objects[0]);
        this.column2.set(row, objects[1]);
    }

    @Override
    protected void pExchange(int row_a, int row_b) {
        this.column1.exchange(row_a, row_b);
        this.column2.exchange(row_a, row_b);
    }

    @Override
    protected void pAdd(Object[] row) {
        this.column1.add(row[0]);
        this.column2.add(row[1]);
    }

    @Override
    protected void pInsert(int row, Object[] objects) {
        this.column1.insert(row, objects[0]);
        this.column2.insert(row, objects[1]);
    }

    @Override
    protected void pRemove(int row) {
        this.column1.remove(row);
        this.column2.remove(row);
    }
}

