/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.form;

import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.filter.FilterText;
import de.mn77.base.error.Err;
import de.mn77.base.error.Warning;

public class FormText {
    public static String sequence(char c, long width) {
        Warning.ifOver(10000L, width);
        Err.ifToSmall(0.0, width);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while ((long)i < width) {
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static String sequence(String s, long count) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((long)i < count) {
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static String width(int width, String s, boolean cutOverflow) {
        return FormText.width(width, ' ', s, POSITION_H.LEFT, cutOverflow);
    }

    public static String width(int width, char fill, String t, POSITION_H align, boolean cutOverflow) {
        Err.ifToSmall(0.0, width);
        Err.ifNull(t, align);
        int space = width - t.length();
        if (align == POSITION_H.CENTER) {
            if (space >= 0) {
                t = String.valueOf(FormText.sequence(fill, (long)((int)Math.floor((double)space / 2.0)))) + t + FormText.sequence(fill, (long)((int)Math.ceil((double)space / 2.0)));
            } else {
                String string = t = cutOverflow ? t.substring(0, t.length() + space) : t;
            }
        }
        if (align == POSITION_H.LEFT) {
            if (space >= 0) {
                t = String.valueOf(t) + FormText.sequence(fill, (long)space);
            } else {
                String string = t = cutOverflow ? t.substring(0, t.length() + space) : t;
            }
        }
        if (align == POSITION_H.RIGHT) {
            t = space >= 0 ? String.valueOf(FormText.sequence(fill, (long)space)) + t : (cutOverflow ? t.substring(-space, t.length()) : t);
        }
        return t;
    }

    public static String length(int length, String s, boolean cutOverflow) {
        return length >= 0 ? FormText.width(length, ' ', s, POSITION_H.LEFT, cutOverflow) : FormText.width(Math.abs(length), ' ', s, POSITION_H.RIGHT, cutOverflow);
    }

    public static String insert(String insertion, int pos, String base) {
        Err.ifNull(insertion, base);
        Err.ifEqual(0, pos);
        Err.ifOutOfBounds(base.length() + 1, pos, new double[0]);
        pos = pos < 0 ? base.length() + pos + 1 : --pos;
        return String.valueOf(base.substring(0, pos)) + insertion + base.substring(pos);
    }

    private static String toSQL_Exec(String s) {
        Err.ifNull(s);
        s = s.replaceAll("'", "''");
        return s;
    }

    public static String toSQL_Text(String s) {
        return "'" + FormText.toSQL_Exec(s) + "'";
    }

    public static String toSQL_Identifier(String s) {
        Err.ifNull(s);
        return FilterText.only(("abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "_").toCharArray(), s);
    }

    public static String toFilename(String s) {
        Err.ifNull(s);
        String allowed = String.valueOf("abcdefghijklmnopqrstuvwxyz\u00df\u00e4\u00f6\u00fc".toUpperCase()) + "abcdefghijklmnopqrstuvwxyz\u00df\u00e4\u00f6\u00fc".toLowerCase() + "0123456789" + "_- #.,'(){}[]&";
        return FilterText.only(allowed.toCharArray(), s);
    }

    public static String capitalizeFirstChar(String s) {
        char[] ca = s.toCharArray();
        char last = ' ';
        int pos = 0;
        while (pos >= 0 && pos < ca.length) {
            Character current = Character.valueOf(ca[pos]);
            if (Character.isLetter(current.charValue()) && !Character.isLetter(last)) {
                ca[pos] = Character.toUpperCase(ca[pos]);
            }
            ++pos;
            last = current.charValue();
        }
        return new String(ca);
    }

    public static String toHTMLChars(String s) {
        s = s.replaceAll("&", "&amp;");
        HTML_CHARS[] hTML_CHARSArray = HTML_CHARS.values();
        int n = hTML_CHARSArray.length;
        int n2 = 0;
        while (n2 < n) {
            HTML_CHARS hc = hTML_CHARSArray[n2];
            s = s.replaceAll("" + hc.chars, hc.html);
            ++n2;
        }
        return s;
    }

    public static String fromHTMLChars(String s) {
        HTML_CHARS[] hTML_CHARSArray = HTML_CHARS.values();
        int n = hTML_CHARSArray.length;
        int n2 = 0;
        while (n2 < n) {
            HTML_CHARS hc = hTML_CHARSArray[n2];
            s = s.replaceAll(hc.html, "" + hc.chars);
            ++n2;
        }
        s = s.replaceAll("&amp;", "&");
        return s;
    }

    public static String fill(String template, String ... values) {
        Err.ifNull(template, values);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Err.ifNull(s);
            ++n2;
        }
        Err.ifToBig(27.0, values.length);
        int i = 0;
        while (i < values.length) {
            String suche = "%" + "abcdefghijklmnopqrstuvwxyz".charAt(i);
            template = template.replaceAll(suche, values[i]);
            ++i;
        }
        return template;
    }

    public static String limit(String s, int maxLength, String finishItWith) {
        Err.ifToSmall(finishItWith.length(), maxLength);
        if (s.length() <= maxLength) {
            return s;
        }
        return String.valueOf(FilterText.cut(maxLength - finishItWith.length(), true, s)) + finishItWith;
    }

    private static enum HTML_CHARS {
        auml('\u00e4', "&auml;"),
        ouml('\u00f6', "&ouml;"),
        uuml('\u00fc', "&uuml;"),
        Auml('\u00c4', "&Auml;"),
        Ouml('\u00d6', "&Ouml;"),
        Uuml('\u00dc', "&Uuml;"),
        szlig('\u00df', "&szlig;"),
        nbsp(' ', "&nbsp;"),
        euro('\u20ac', "&euro;"),
        lt('<', "&lt;"),
        gt('>', "&gt;");

        private final char chars;
        private final String html;

        private HTML_CHARS(char c, String html) {
            this.chars = c;
            this.html = html;
        }
    }
}

