/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.magic.var.MC_APP;
import org.jmo_lang.object.magic.var.MC_JMO;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.struct.runtime.Instance;
import org.jmo_lang.tools.Lib_Convert;

public class Lib_Type {
    public static void parsetimeCheckTypename(String newName, Parser_Script parser) {
        Lib_Type.checkTypeValidity(newName, parser, parser.gDebugInfo());
    }

    public static void parsetimeCheckTypename(String newName, Parser_Script parser, DebugInfo debug) {
        Lib_Type.checkTypeValidity(newName, parser, debug);
    }

    public static void checkTypeValidity(String typeName, DebugInfo debug) {
        Lib_Type.checkTypeValidity(typeName, null, debug);
    }

    private static void checkTypeValidity(String typeName, Parser_Script parser, DebugInfo debug) {
        char cl;
        boolean parsetime;
        boolean bl = parsetime = parser != null;
        if (typeName.length() == 0) {
            Lib_Type.invalidTypename("Type can't be empty!", parsetime, debug);
        }
        if ((cl = typeName.charAt(typeName.length() - 1)) == '_') {
            Lib_Type.invalidTypename("Type can't end with underline! Got: " + typeName, parsetime, debug);
        }
        int underlines = 0;
        boolean nextCapital = true;
        char[] cArray = typeName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char cx = cArray[n2];
            if (nextCapital && (cx < 'A' || cx > 'Z')) {
                Lib_Type.invalidTypename("Type must start with a capital letter! Got: " + typeName, parsetime, debug);
            }
            nextCapital = false;
            if (!(cx >= 'A' && cx <= 'Z' || cx >= 'a' && cx <= 'z' || cx >= '0' && cx <= '9')) {
                if (cx == '_') {
                    ++underlines;
                    nextCapital = true;
                } else {
                    Lib_Type.invalidTypename("Invalid char '" + cx + "'! Got: " + typeName, parsetime, debug);
                }
            }
            ++n2;
        }
        if (underlines > 1) {
            Lib_Type.invalidTypename("Type can't have multiple underlines and namespaces: " + typeName, parsetime, debug);
        }
    }

    private static void invalidTypename(String detail, boolean parsetime, DebugInfo debug) {
        if (parsetime) {
            throw new ParseError("Invalid Type-Name!", detail, debug);
        }
        throw new ExecError("Invalid Type-Name!", detail, debug);
    }

    public static Class<?> getType(CallRuntime cr, I_Object o) {
        o = Lib_Convert.getValue(cr, o);
        return o.getClass();
    }

    public static boolean typeIs(CallRuntime cr, I_Object o, Class<?> ... ta) {
        o = Lib_Convert.getValue(cr, o);
        Class<?> typ = o.getClass();
        Class<?>[] classArray = ta;
        int n = ta.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (t.isAssignableFrom(typ)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getName(I_Object obj) {
        return Lib_Type.getName(obj.getClass(), obj);
    }

    public static String getName(Class<?> objClass, I_Object obj) {
        Err.ifNull(objClass);
        if (objClass == App.class || objClass == MC_APP.class) {
            return "App";
        }
        if (objClass == Function.class) {
            return "func";
        }
        if (objClass == Handle_Loop.class) {
            return "loop";
        }
        if (objClass == MC_JMO.class || objClass == MC_APP.class) {
            return obj.toString();
        }
        if (objClass == Var.class) {
            return "Var";
        }
        if (objClass == Const.class) {
            return "Const";
        }
        if (objClass == VarLet.class) {
            return "VarLet";
        }
        String s = objClass.getSimpleName();
        if (objClass == Instance.class) {
            String string = s = obj == null ? Instance.class.getSimpleName() : ((Instance)obj).getType().getName();
        }
        if (s.startsWith("JMo_")) {
            return s.substring(4);
        }
        if (s.startsWith("A_")) {
            return s.substring(2);
        }
        if (s.equals("I_AtomicValue")) {
            return "Atomic";
        }
        if (s.startsWith("I_")) {
            Err.todo(s);
        }
        return s;
    }

    public static boolean isInstanceOf(I_Object o, String type) {
        String[] stringArray = o.getTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String typesToString(I_Object obj) {
        String[] types = obj.getTypes();
        StringBuilder sb = new StringBuilder();
        if (types.length > 1) {
            sb.append("(");
        }
        int tc = 0;
        while (tc < types.length) {
            String type = types[tc];
            if (tc != 0) {
                sb.append(", ");
            }
            sb.append(type);
            ++tc;
        }
        if (types.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }
}

