/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.group.Group2;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.tools.Lib_Parser;

public class Lib_StringParser {
    public static final int checkChar(String s, boolean throwError, DebugInfo debugInfo) {
        if (s.length() >= 8 && s.charAt(1) == '\\' && s.charAt(2) == 'u' && s.charAt(7) == '\'') {
            return 8;
        }
        if (s.length() >= 4 && s.charAt(1) == '\\' && s.charAt(3) == '\'') {
            return 4;
        }
        if (s.length() >= 3 && s.charAt(2) == '\'') {
            return 3;
        }
        if (throwError) {
            throw new ParseError("Unclosed char", s, debugInfo);
        }
        return -1;
    }

    public static final int checkGetOrList(String s, int offset, boolean throwError, DebugInfo debugInfo) {
        char[] ca = s.toCharArray();
        int depth = 0;
        int pos = offset;
        while (pos < ca.length) {
            char c = ca[pos];
            if (c == '\\') {
                ++pos;
            } else {
                if (c == '[') {
                    ++depth;
                }
                if (c == ']') {
                    --depth;
                }
                if (c == '(') {
                    pos += 1 + Lib_StringParser.checkGroup(s, pos, true, debugInfo);
                } else if (c == '\"') {
                    pos += 1 + Lib_StringParser.checkString(s.substring(pos), true, debugInfo);
                } else if (c == '\'') {
                    pos += Lib_StringParser.checkChar(s.substring(pos), true, debugInfo) - 1;
                } else if (depth == 0) {
                    return pos;
                }
            }
            ++pos;
        }
        if (throwError) {
            throw new ParseError("Unclosed get/list", s, debugInfo);
        }
        return -1;
    }

    public static final boolean checkGetSet(String s, char open, char close) {
        int level = 0;
        char[] ca = s.toCharArray();
        int pos = 1;
        while (pos < ca.length) {
            char c = ca[pos];
            if (c == open) {
                ++level;
            } else if (c == close) {
                if (level == 0) {
                    return true;
                }
                --level;
            }
            ++pos;
        }
        return false;
    }

    public static final int checkGroup(String s, int offset, boolean throwError, DebugInfo debugInfo) {
        char[] ca = s.toCharArray();
        int depth = 0;
        int pos = offset;
        while (pos < ca.length) {
            char c = ca[pos];
            if (c == '\\') {
                ++pos;
            } else {
                if (c == '(') {
                    ++depth;
                }
                if (c == ')') {
                    --depth;
                }
                if (c == '\"') {
                    pos += 1 + Lib_StringParser.checkString(s.substring(pos), true, debugInfo);
                } else if (c == '\'') {
                    pos += Lib_StringParser.checkChar(s.substring(pos), true, debugInfo) - 1;
                } else if (depth == 0) {
                    return pos;
                }
            }
            ++pos;
        }
        if (throwError) {
            throw new ParseError("Unclosed group", s, debugInfo);
        }
        return -1;
    }

    public static final int checkString(String s, boolean throwError, DebugInfo debugInfo) {
        int sLen = s.length();
        int pos = 1;
        while (pos < sLen) {
            char c = s.charAt(pos);
            if (c == '\\') {
                ++pos;
            } else if (c == '\"') {
                return pos - 1;
            }
            ++pos;
        }
        if (throwError) {
            throw new ParseError("Unclosed string", s, debugInfo);
        }
        return -1;
    }

    public static int search(String s, int offset, char open, char close, char search, DebugInfo debugInfo) {
        int deep = 0;
        char[] ca = s.toCharArray();
        int pos = offset;
        while (pos < s.length()) {
            char c = ca[pos];
            if (c == open) {
                ++deep;
            }
            if (c == close) {
                --deep;
            }
            if (c == search && deep == 0) {
                return pos;
            }
            if (c == '\"') {
                pos += 1 + Lib_StringParser.checkString(s.substring(pos), true, debugInfo);
            } else if (c == '\'') {
                pos += Lib_StringParser.checkChar(s.substring(pos), true, debugInfo) - 1;
            } else if (c == '[') {
                pos += Lib_Parser.group('[', ']', s.substring(pos), debugInfo).length();
            } else if (c == '{') {
                pos += Lib_Parser.group('{', '}', s.substring(pos), debugInfo).length();
            }
            ++pos;
        }
        return -1;
    }

    public static Group2<String, String> getNextPar(String s, DebugInfo debug) {
        int offset = 0;
        int offsetStart = s.charAt(0) == '?' ? 1 : 0;
        switch (s.charAt(offsetStart)) {
            case '[': {
                offset = Lib_Parser.group('[', ']', s, debug).length() + 2;
                break;
            }
            case '{': {
                offset = Lib_Parser.group('{', '}', s, debug).length() + 2;
            }
        }
        int index = Lib_StringParser.search(s, offset, '(', ')', ',', debug);
        String par = index == -1 ? s : s.substring(0, index);
        String rem = index == -1 ? "" : s.substring(index + 1);
        return new Group2<String, String>(par, rem);
    }
}

