/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group3;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.parser.Parser_Call;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.FunctionPar;
import org.jmo_lang.tools.Lib_StringParser;

public class Lib_Parser {
    public static int getDepth(String s) {
        int count = 0;
        int pos = 0;
        while (pos < s.length()) {
            if (s.charAt(pos) == '\t') {
                ++count;
            } else {
                return count;
            }
            ++pos;
        }
        return count;
    }

    public static Group3<I_List<FunctionPar>, Integer, Boolean> getFunctionPars(Parser_Script parser, Block current, String s, char open, char close) {
        int begin = s.indexOf(open);
        String s2 = s.substring(begin);
        String ps = Lib_Parser.group(open, close, s2, parser.gDebugInfo());
        int rem = begin + ps.length() + 2;
        ps = ps.trim();
        String[] psa = ps.split(",");
        MList pars = new MList();
        boolean varargs = false;
        String[] stringArray = psa;
        int n = psa.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String sa = element.trim();
            if (sa.length() != 0) {
                char pName0;
                if (sa.endsWith("...")) {
                    varargs = true;
                    sa = sa.substring(0, sa.length() - 3);
                }
                String pType = sa.replaceFirst("(\\s*[A-Z][A-Za-z0-9_]*\\s+)?[a-zA-Z][A-Za-z0-9_]*[?\u00bf]?[?]?\\s*(=[^,]+)?", "$1");
                String pDef = sa.replaceFirst("(\\s*[A-Z][A-Za-z0-9_]*\\s+)?[a-zA-Z][A-Za-z0-9_]*[?\u00bf]?[?]?\\s*(=[^,]+)?", "$2");
                String pName = sa.substring(pType.length(), sa.length() - pDef.length());
                pType = pType.trim();
                pName = pName.trim();
                pDef = pDef.trim();
                if (pType.length() == 0) {
                    pType = null;
                }
                if (pName.length() == 0) {
                    pName = null;
                }
                if (pDef.length() > 0) {
                    pDef = pDef.substring(1);
                }
                I_Object pDefC = null;
                if (pDef.length() > 0) {
                    Group2<I_Object, String> g = Parser_Call.parseObject(parser, current, pDef, true);
                    if (g.o2 != null && ((String)g.o2).length() > 0) {
                        Err.forbidden(g.o2);
                    }
                    pDefC = (I_Object)g.o1;
                }
                boolean fix = (pName0 = pName.charAt(0)) >= 'A' && pName0 <= 'Z';
                parser.app.strict.checkFuncParType(pType, pName, parser.gDebugInfo());
                FunctionPar fpar = new FunctionPar(pType, fix, pName, pDefC);
                pars.add(fpar);
            }
            ++n2;
        }
        return new Group3<I_List<FunctionPar>, Integer, Boolean>(pars, rem, varargs);
    }

    public static final String group(char open, char close, String s, DebugInfo debugInfo) {
        int deep = 0;
        int start = -1;
        int pos = 0;
        while (pos < s.length()) {
            char c = s.charAt(pos);
            if (c == open) {
                ++deep;
                if (start == -1) {
                    start = pos;
                }
            }
            if (c == '\"') {
                pos += 1 + Lib_StringParser.checkString(s.substring(pos), true, debugInfo);
            } else if (c == '\'') {
                pos += Lib_StringParser.checkChar(s.substring(pos), true, debugInfo) - 1;
            } else if (c == close && --deep == 0) {
                return s.substring(start + 1, pos);
            }
            ++pos;
        }
        if (deep == 0) {
            return s;
        }
        throw new ParseError("Uncomplete " + open + close + " group", "Missing: '" + close + "', got only: " + s, debugInfo);
    }

    public static char replaceEscapeChar(char c, DebugInfo debugInfo) {
        switch (c) {
            case '\\': {
                return c;
            }
            case '\'': {
                return c;
            }
            case '\"': {
                return c;
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'b': {
                return '\b';
            }
        }
        throw new ParseError("Unknown char", "" + c, debugInfo);
    }

    public static char replaceUtfChar(String s, int pos, DebugInfo debugInfo) {
        Err.ifToSmall(pos + 5, s.length());
        String hex = s.substring(pos + 1, pos + 5);
        if (pos + 5 > s.length()) {
            throw new ParseError("Uncomplete UTF-Character", "Got: " + hex, debugInfo);
        }
        int value = 0;
        try {
            value = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException nfe) {
            throw new ParseError("Invalid unicode statement", "Got: \\" + s.substring(pos), debugInfo);
        }
        char cv = (char)value;
        return cv;
    }

    public static String setDepth(int d, String s) {
        s = s.trim();
        return String.valueOf(Lib_String.sequence('\t', (long)d)) + s;
    }

    public static final String space(int level) {
        return Lib_String.sequence(' ', (long)(level * 2));
    }

    public static final Group2<String, Integer> stringGet(String s, DebugInfo debugInfo) {
        char[] ca = s.toCharArray();
        StringBuilder sb = new StringBuilder(ca.length);
        int idx = 1;
        while (idx < ca.length) {
            char c = ca[idx];
            switch (c) {
                case '\\': {
                    char temp = ca[++idx];
                    if (temp == 'u') {
                        char utf = Lib_Parser.replaceUtfChar(s, idx, debugInfo);
                        sb.append(utf);
                        idx += 4;
                        break;
                    }
                    sb.append(Lib_Parser.replaceEscapeChar(temp, debugInfo));
                    break;
                }
                case '\"': {
                    return new Group2<String, Integer>(sb.toString(), idx);
                }
                default: {
                    sb.append(c);
                }
            }
            ++idx;
        }
        return null;
    }

    public static Group3<String, Integer, Boolean> stringRegexGet(String s, DebugInfo debugInfo) {
        int end = 1;
        int sLen = s.length();
        boolean reworkNeeded = false;
        end = 1;
        while (end < sLen) {
            char c = s.charAt(end);
            if (c == '\\') {
                ++end;
                reworkNeeded = true;
            } else if (c == '\"') break;
            ++end;
        }
        if (end == sLen) {
            throw new ParseError("Unclosed string", s, debugInfo);
        }
        String str = s.substring(1, end);
        if (end + 1 < sLen && s.charAt(end + 1) == '?') {
            return new Group3<String, Integer, Boolean>(str, end + 1, true);
        }
        if (!reworkNeeded) {
            return new Group3<String, Integer, Boolean>(str, end, false);
        }
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        int idx = 0;
        while (idx < strLen) {
            char c = str.charAt(idx);
            if (c == '\\') {
                if ((c = str.charAt(++idx)) == 'u') {
                    char utf = Lib_Parser.replaceUtfChar(str, idx, debugInfo);
                    sb.append(utf);
                    idx += 4;
                } else {
                    sb.append(Lib_Parser.replaceEscapeChar(c, debugInfo));
                }
            } else {
                sb.append(c);
            }
            ++idx;
        }
        return new Group3<String, Integer, Boolean>(sb.toString(), end, false);
    }
}

