/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Error;

public class Lib_Function {
    public static byte isVarFunction(String method) {
        switch (method) {
            case "=": 
            case "=~": 
            case "let": 
            case "convertLet": {
                return 1;
            }
            case "notLet": 
            case "=!": 
            case "=**": 
            case "=++": 
            case "=--": 
            case "=//": 
            case "=<<": 
            case "=>>": {
                return 0;
            }
            case "addLet": 
            case "andLet": 
            case "divLet": 
            case "modLet": 
            case "mulLet": 
            case "subLet": 
            case "bitAndLet": 
            case "xorLet": 
            case "bitXorLet": 
            case "%=": 
            case "&=": 
            case "*=": 
            case "+=": 
            case "-=": 
            case "/=": 
            case "^=": 
            case "|=": 
            case "&&=": 
            case "**=": 
            case "++=": 
            case "--=": 
            case "//=": 
            case "<<=": 
            case ">>=": 
            case "^^=": 
            case "||=": 
            case "orLet": 
            case "bitOrLet": {
                return 1;
            }
            case "shiftRightLet": 
            case "sqrtLet": 
            case "shiftLeftLet": 
            case "decLet": 
            case "incLet": 
            case "powLet": {
                return 2;
            }
        }
        return -1;
    }

    public static I_Object calcLet(CallRuntime cr, String method, byte methodParState, I_Object oldVarValue) {
        if (methodParState == 2) {
            byte by = methodParState = cr.parCount() == 0 ? (byte)0 : 1;
        }
        if (methodParState == 0) {
            return Lib_Function.calcLetNoPar(cr, method, oldVarValue);
        }
        if (methodParState == 1) {
            return Lib_Function.calcLetWithPar(cr, method, oldVarValue);
        }
        throw Err.todo(method);
    }

    private static I_Object calcLetWithPar(CallRuntime cr, String method, I_Object oldVarValue) {
        Lib_Error.ifPars(cr.parCount(), 1, 1, cr);
        String calcMethod = Lib_Function.iConvertMethod(method);
        Call c3 = new Call(cr.getSurrBlock(), oldVarValue, calcMethod, cr.call.parCalls, cr.getDebugInfo());
        CallRuntime crx = cr.copyCall(c3, false);
        return crx.exec(null, true);
    }

    private static I_Object calcLetNoPar(CallRuntime cr, String method, I_Object oldVarValue) {
        Call[] callArray;
        Lib_Error.ifPars(cr.parCount(), 0, 0, cr);
        String calcMethod = Lib_Function.iConvertMethod(method);
        char c0 = calcMethod.charAt(0);
        int par = 1;
        if (c0 == '*' || c0 == '/' || c0 == 'p' || c0 == 's') {
            par = 2;
        }
        if (c0 == '!' || c0 == 'n') {
            par = 0;
        }
        if (par == 0) {
            callArray = new Call[]{};
        } else {
            Call[] callArray2 = new Call[1];
            callArray = callArray2;
            callArray2[0] = new Call(cr.getSurrBlock(), new Int(par), cr.getDebugInfo());
        }
        Call[] parCalls = callArray;
        Call c3 = new Call(cr.getSurrBlock(), oldVarValue, calcMethod, parCalls, cr.getDebugInfo());
        CallRuntime crx = cr.copyCall(c3, false);
        return crx.exec(null, true);
    }

    private static String iConvertMethod(String method) {
        if (method.charAt(0) == '=') {
            method = method.substring(1);
        }
        if (method.endsWith("=")) {
            method = method.substring(0, method.length() - 1);
        }
        if (method.endsWith("Let")) {
            method = method.substring(0, method.length() - 3);
        }
        return method;
    }
}

