/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.tools;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ReturnException;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.pseudo.VarLet;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;

public class Lib_Exec {
    public static void checkIsReturn(CallRuntime cr, ReturnException e) {
        Return temp = e.get();
        if (temp.getLevel() != Return.LEVEL.END) {
            throw new ExecError(cr, "Invalid Return-Type", "Got " + (Object)((Object)temp.getLevel()));
        }
    }

    public static I_Object onePar(CallRuntime cr, I_Object itStream, int min, int max) {
        Err.ifToBig(1.0, max);
        I_Object[] pars = cr.parsFlex(itStream, min, max);
        return pars.length == 0 ? Nil.NIL : pars[0];
    }

    public static I_Object execBlockStream(CallRuntime cpNew, BlockExecArgs args, I_Object it) {
        if (args.fixval) {
            it = args.par;
        }
        if (args.varlet) {
            Var o = ((VarLet)args.par).getVar();
            o.let(cpNew, cpNew, it);
        }
        return Lib_Exec.execBlockStream(cpNew, it);
    }

    public static I_Object execBlockStream(CallRuntime cpNew, I_Object it) {
        Call stream = cpNew.getStream();
        Block block = cpNew.getCallBlock();
        if (block != null) {
            try {
                it = block.exec(cpNew, it);
            }
            catch (ReturnException e) {
                Return r = e.get();
                if (r.getResult() == Nil.NIL) {
                    r.setResult(it);
                }
                return r;
            }
        }
        if (stream != null) {
            it = cpNew.execInit(stream, it);
        }
        return it;
    }

    public static void checkLoopWithout(CallRuntime cpOld, I_Object[] pars) {
        if (pars.length == 0 && cpOld.getStream() == null && cpOld.getCallBlock() == null) {
            throw new CodeError(cpOld, "Invalid call", "No parameter, no stream, no block ... what should I do?");
        }
    }

    public static I_Object loopResult(I_Object result) {
        if (result instanceof Return && ((Return)result).getLevel() == Return.LEVEL.NEXT) {
            return ((Return)result).getResult();
        }
        return result;
    }

    public static I_Object execIf(CallRuntime cr, Block block, Call stream, boolean check, I_Object it, I_Object its, boolean passToStream, I_Object res) {
        if (check) {
            if (block != null) {
                try {
                    res = block.exec(cr, it);
                }
                catch (ReturnException e) {
                    return e.get();
                }
            }
            if (stream != null) {
                res = cr.execInit(stream, its);
            }
        } else if (block != null && stream != null && !passToStream) {
            res = cr.execInit(stream, its);
        }
        return res;
    }

    public static Str execJMo(CallRuntime cr, String value, String infoTypeFunc, boolean hotDirect) {
        cr.getStrict().checkSave(cr, infoTypeFunc);
        try {
            Parser_App parser = new Parser_App();
            App appHot = parser.parseText(value);
            appHot.setOutputFile(cr.getApp().getOutputFile());
            String result = hotDirect ? cr.getApp().exec(cr, appHot) : appHot.exec(null);
            return new Str(result);
        }
        catch (Err_FileSys e) {
            Err.show(e);
            throw new ExecError(cr, "Execution-Error", e.getMessage());
        }
    }
}

