/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.util.HashMap;
import java.util.Map;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_DecNumber;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Decimal;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.passthrough.Const;
import org.jmo_lang.object.passthrough.I_VarConst;
import org.jmo_lang.object.passthrough.Var;
import org.jmo_lang.struct.ObjectManager;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Type;

public class VarEnv {
    private final VarEnv parent;
    private final String varConstStr;
    private HashMap<String, Group2<String, I_Object>> list = null;
    private I_Object itValue = Nil.NIL;

    public VarEnv(VarEnv parent, boolean isConst) {
        this.parent = parent;
        this.varConstStr = isConst ? "constant" : "variable";
    }

    public void describe(int left) {
        this.init();
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + this.toString());
        for (Map.Entry<String, Group2<String, I_Object>> g : this.list.entrySet()) {
            MOut.text(String.valueOf(space) + "  " + g.getKey() + " --> " + ((I_Object)g.getValue().o2).toString());
        }
        MOut.text(String.valueOf(space) + "Parent:");
        if (this.parent == null) {
            MOut.text(String.valueOf(space) + "  nil");
        } else {
            this.parent.describe(left + 1);
        }
    }

    public I_Object get(CallRuntime cr, I_VarConst var) {
        if (var.getName().equals("it")) {
            return this.itValue;
        }
        this.init();
        if (this.list.containsKey(var.getName())) {
            I_Object result = (I_Object)this.list.get((Object)var.getName()).o2;
            return result == null ? Nil.NIL : result;
        }
        if (this.parent != null && this.parent.knows(var)) {
            return this.parent.get(cr, var);
        }
        throw new CodeError(cr, "Access to uninitialized " + this.varConstStr, var.getName());
    }

    public I_Object get(CallRuntime cr, I_VarConst var, I_Object ifNotSet) {
        this.init();
        return this.knows(var) ? this.get(cr, var) : ifNotSet;
    }

    public String getType(Var var) {
        Group2 g = this.list.getOrDefault(var, null);
        return g == null ? null : (String)g.o1;
    }

    public void setType(CallRuntime cr, I_VarConst vc, String type) {
        if (!ObjectManager.isTypeKnown(cr, type)) {
            throw new CodeError(cr, "Unknown Type", "Got: " + type);
        }
        Group2 g = this.list.getOrDefault(vc, null);
        if (g != null) {
            Err.invalid("Type already set!");
        }
        this.list.put(vc.getName(), new Group2<String, Object>(type, null));
    }

    public boolean isInitialized(Var var) {
        return this.knows(var);
    }

    public boolean knows(I_VarConst var) {
        String name = var.getName();
        if (name.equals("it")) {
            return true;
        }
        this.init();
        return this.list.containsKey(name) ? true : (this.parent != null ? this.parent.knows(var) : false);
    }

    public void remove(Var v) {
        if (this.list == null) {
            return;
        }
        this.list.remove(v.getName());
    }

    public void set(CallRuntime cr, I_VarConst var, I_Object obj, boolean typesafe, boolean nilable, boolean convert) {
        String varName = var.getName();
        if (obj == null) {
            throw new CodeError(cr, "No Object to set", varName);
        }
        if (varName.equals("it")) {
            this.itValue = Lib_Convert.getValue(cr, obj);
            return;
        }
        this.init();
        if (!this.list.containsKey(varName) && this.parent != null && this.parent.knows(var)) {
            this.parent.set(cr, var, obj, typesafe, nilable, convert);
            return;
        }
        String objType = Lib_Type.getName(obj.getClass(), obj);
        String safedType = null;
        if (this.list.containsKey(varName)) {
            safedType = (String)this.list.get((Object)varName).o1;
        }
        obj = Lib_Convert.getValue(cr, obj);
        if (var instanceof Const && this.list.get(varName) != null && this.list.get((Object)varName).o2 != null) {
            throw new ExecError(cr, "Const already set", String.valueOf(varName) + "=" + obj.toString());
        }
        if (!nilable && obj == Nil.NIL) {
            throw new ExecError(cr, "Assign Nil to a not nillable " + this.varConstStr, String.valueOf(varName) + "=" + Nil.NIL.toString());
        }
        if (obj != null) {
            if (!this.list.containsKey(varName)) {
                if (typesafe && !objType.equals("Nil")) {
                    safedType = objType;
                }
            } else {
                String defType = (String)this.list.get((Object)varName).o1;
                if (defType != null && convert) {
                    obj = this.iConvert(defType, objType, obj);
                    objType = Lib_Type.getName(obj);
                }
                if (typesafe && !objType.equals("Nil") && defType != null && !Lib_Type.isInstanceOf(obj, defType)) {
                    throw new ExecError(cr, "Invalid type for " + this.varConstStr + "!", "(" + defType + ") <-- (" + objType + ") " + obj);
                }
            }
        }
        this.list.put(varName, new Group2<String, I_Object>(safedType, obj));
    }

    public String toDebug(CallRuntime cr, I_VarConst var, String ifNotSet) {
        this.init();
        return this.list.containsKey(var.getName()) ? this.get(cr, var).toDebug(cr) : ifNotSet;
    }

    public String toString() {
        String sll = this.list == null ? "null" : "" + this.list.size();
        String sp = this.parent == null ? "" : " --> Parent: " + this.parent;
        return "VarEnv (Size:" + sll + ")" + sp;
    }

    private void init() {
        if (this.list == null) {
            this.list = new HashMap();
        }
    }

    private I_Object iConvert(String defType, String objType, I_Object obj) {
        block28: {
            boolean objIsInt;
            block26: {
                boolean objIsDec = obj instanceof I_Decimal;
                if (!objIsDec) break block26;
                switch (defType) {
                    case "Byte": {
                        return new JMo_Byte(((Number)((A_DecNumber)obj).getValue()).byteValue());
                    }
                    case "Short": {
                        return new JMo_Short(((Number)((A_DecNumber)obj).getValue()).shortValue());
                    }
                    case "Int": {
                        return new Int(((Number)((A_DecNumber)obj).getValue()).intValue());
                    }
                    case "Long": {
                        return new JMo_Long(((Number)((A_DecNumber)obj).getValue()).longValue());
                    }
                }
            }
            if (!(objIsInt = obj instanceof I_Integer)) break block28;
            switch (defType) {
                case "Float": {
                    return new JMo_Float(((Number)((A_IntNumber)obj).getValue()).floatValue());
                }
                case "Dec": {
                    return new Dec(((Number)((A_IntNumber)obj).getValue()).doubleValue());
                }
            }
        }
        return obj;
    }
}

