/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct.hints;

import de.mn77.base.data.convert.ConvArray;
import de.mn77.base.data.convert.ConvText;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.data.struct.table.type.TypeTable2;
import java.util.Collection;
import org.jmo_lang.struct.hints.A_HintFile;

public class HintTypes
extends A_HintFile {
    private TypeTable2<String, String[]> types;

    public HintTypes() {
        super(A_HintFile.TYPE.TYPES);
    }

    public void add(String name, String[] types) {
        this.types.add(name, types);
    }

    @Override
    public void clear() {
        this.types = new TypeTable2<String, String[]>(String.class, String[].class);
    }

    public String[] getType(String typ) {
        this.loadDefault();
        int tz = 1;
        while (tz <= this.types.size()) {
            if (((String)this.types.getCol1().get(tz)).equals(typ)) {
                String[] ttypes = (String[])this.types.getCol2().get(tz);
                return ttypes;
            }
            ++tz;
        }
        return null;
    }

    public Collection<String> searchTypes(String search) {
        this.loadDefault();
        MList<String> result = new MList<String>();
        for (String s : this.types.getCol1()) {
            if (!s.startsWith(search)) continue;
            result.add(s);
        }
        result.sort(1);
        return result;
    }

    @Override
    protected void cleanUp() {
        this.types.sort(1);
        int z = this.types.size();
        while (z > 1) {
            if (this.types.get(1, z).equals(this.types.get(1, z - 1))) {
                this.types.remove(z);
            }
            --z;
        }
    }

    @Override
    protected I_Table<String> getCSVTable() {
        this.cleanUp();
        MTable<String> table = new MTable<String>(2);
        for (Group2 group2 : this.types) {
            table.add((String[])new String[]{(String)group2.o1, ConvArray.toString("|", (Object[])group2.o2)});
        }
        return table;
    }

    @Override
    protected boolean isEmpty() {
        return this.types.isEmpty();
    }

    @Override
    protected void pAddLineFromCSV(I_Sequence<String> line) {
        String[] types2 = ConvText.toStringArray("|", line.get(2));
        this.types.add(line.get(1), types2);
    }
}

