/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class VarArgsCallBuffer {
    private final Call[] calls;
    private final I_Object obj = null;
    private boolean init = false;

    public VarArgsCallBuffer(Call[] ca) {
        Err.ifNull(new Object[]{ca});
        this.calls = ca;
    }

    public I_Object[] init(CallRuntime cr, I_Object streamIt) {
        if (this.init) {
            Err.todo("Already init!", this.obj);
        }
        I_Object[] result = new I_Object[this.calls.length];
        int i = 0;
        while (i < this.calls.length) {
            result[i] = cr.execInit(this.calls[i], streamIt);
            ++i;
        }
        this.init = true;
        return result;
    }

    public I_Object get() {
        if (!this.init) {
            Err.invalid("VarArgCallBuffer not initialized!", this.calls);
        }
        return this.obj;
    }

    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        Call[] callArray = this.calls;
        int n = this.calls.length;
        int n2 = 0;
        while (n2 < n) {
            Call call = callArray[n2];
            MOut.text(String.valueOf(space) + call.toDebug(cr));
            ++n2;
        }
    }

    public String toDebug(CallRuntime cr) {
        return Lib_Output.toDebug(cr, this.calls);
    }

    public String toString() {
        return this.obj != null ? Lib_Output.toString(this.obj, true) : Lib_Output.toString(this.calls, false);
    }
}

