/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.data.search.SearchArray;
import de.mn77.base.data.struct.set.MSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jmo_lang.dev.JMo_Sandbox;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ErrorBaseDebug;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Group;
import org.jmo_lang.object.JMo_Random;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.JMo_Timer;
import org.jmo_lang.object.JMo_Use;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.classic.JMo_Break;
import org.jmo_lang.object.classic.JMo_Count;
import org.jmo_lang.object.classic.JMo_For;
import org.jmo_lang.object.classic.JMo_If;
import org.jmo_lang.object.classic.JMo_IfNot;
import org.jmo_lang.object.classic.JMo_Next;
import org.jmo_lang.object.classic.JMo_Repeat;
import org.jmo_lang.object.classic.JMo_Switch;
import org.jmo_lang.object.classic.JMo_Try;
import org.jmo_lang.object.classic.JMo_While;
import org.jmo_lang.object.datetime.JMo_Date;
import org.jmo_lang.object.datetime.JMo_DateTime;
import org.jmo_lang.object.datetime.JMo_Time;
import org.jmo_lang.object.filesys.JMo_Dir;
import org.jmo_lang.object.filesys.JMo_File;
import org.jmo_lang.object.filesys.JMo_Path;
import org.jmo_lang.object.filesys.JMo_PathList;
import org.jmo_lang.object.filesys.JMo_RandomAccessFile;
import org.jmo_lang.object.pseudo.JMo_Error;
import org.jmo_lang.object.pseudo.NonAtomic;
import org.jmo_lang.object.pseudo.NonAtomicJava;
import org.jmo_lang.object.pseudo.NonAtomicSelf;
import org.jmo_lang.object.struct.JMo_FunctionMap;
import org.jmo_lang.object.struct.JMo_KeyValue;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_Makro;
import org.jmo_lang.object.struct.JMo_Map;
import org.jmo_lang.object.struct.JMo_Table;
import org.jmo_lang.object.struct.JMo_Tree;
import org.jmo_lang.object.struct.JMo_TreeNode;
import org.jmo_lang.object.sys.JMo_Cmd;
import org.jmo_lang.object.sys.JMo_Input;
import org.jmo_lang.object.sys.JMo_Java;
import org.jmo_lang.object.sys.JMo_Sys;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.Type;
import org.jmo_lang.struct.hints.HintManager;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.ClassFinder;
import org.jmo_lang.tools.Lib_Namespace;
import org.jmo_lang.tools.Lib_Type;

public class ObjectManager {
    public static I_Object get(App app, Block current, String current_namespace, String name, Call[] pars, DebugInfo debugInfo) {
        String search;
        I_Object found;
        char c0 = name.charAt(0);
        if (c0 == 'S' && name.startsWith("Std_")) {
            if ((name = Lib_Namespace.cutStd(name)).equals("Java")) {
                return ObjectManager.iJava(app, pars, debugInfo);
            }
            return ObjectManager.get(app, name, pars, debugInfo, true);
        }
        boolean nameWithNamespace = Lib_Namespace.isNameWithNamespace(name);
        if (nameWithNamespace && name.startsWith("Java_")) {
            String javaclass = Lib_Namespace.cutJava(name);
            Call[] pars2 = new Call[]{new Call(current, new Str(javaclass), debugInfo), new Call(current, pars == null ? new JMo_List() : new JMo_List(pars), debugInfo)};
            return ObjectManager.iJava(app, pars2, debugInfo);
        }
        if (c0 == 'J' && name.equals("Java")) {
            return ObjectManager.iJava(app, pars, debugInfo);
        }
        if (nameWithNamespace) {
            return ObjectManager.get(app, name, pars, debugInfo, true);
        }
        if (current_namespace != null && (found = ObjectManager.get(app, search = String.valueOf(current_namespace) + '_' + name, pars, debugInfo, false)) != null) {
            return found;
        }
        return ObjectManager.get(app, name, pars, debugInfo, true);
    }

    private static I_Object get(App app, String name, Call[] pars, DebugInfo debugInfo, boolean error) {
        String r;
        String[] stringArray = ATOMIC.ATOMIC_TYPENAMES;
        int n = ATOMIC.ATOMIC_TYPENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            r = stringArray[n2];
            if (name.equals(r)) {
                throw ObjectManager.atomic(name, debugInfo);
            }
            ++n2;
        }
        stringArray = ATOMIC.ABSTRACT_TYPES;
        n = ATOMIC.ABSTRACT_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            r = stringArray[n2];
            if (name.equals(r)) {
                throw ObjectManager.atomic(name, debugInfo);
            }
            ++n2;
        }
        Class<? extends I_Object> c = ObjectManager.iAssignType(app, name, debugInfo);
        if (c != null) {
            return new NonAtomic(c, pars);
        }
        Class<?> c2 = ObjectManager.getClass(name, app.isDebug());
        if (c2 != null) {
            if (I_Object.class.isAssignableFrom(c2)) {
                return new NonAtomic(c2, pars);
            }
            return new NonAtomic(JMo_Sandbox.class, c2, pars);
        }
        Type t = app.getType().getType(name);
        if (t != null) {
            return new NonAtomicSelf(t, pars);
        }
        Class<?> c3 = ClassFinder.getInstance(app.isDebug()).getJavaClass(name);
        if (c3 != null) {
            app.strict.checkJavaDirect(debugInfo);
            return new JMo_Java(c3, pars, debugInfo);
        }
        if (error) {
            throw new ParseError("Unknown type", name, debugInfo);
        }
        return null;
    }

    private static I_Object iJava(App app, Call[] pars, DebugInfo debugInfo) {
        app.strict.checkSave(debugInfo, "Java");
        return new NonAtomicJava(pars);
    }

    public static Class<?> getClass(String search, boolean debug) {
        return ClassFinder.getInstance(debug).getJMoClass("JMo_" + search);
    }

    public static ArrayList<String> search(HintManager hm, String search, boolean debug) {
        MSet<String> set = new MSet<String>();
        Collection<Class<?>> l = ClassFinder.getInstance(debug).getJMoClasses();
        for (Class<?> c : l) {
            String name = Lib_Type.getName(c, null);
            if (!name.startsWith(search)) continue;
            set.add(name);
        }
        Collection<String> hints = hm.searchTypes(search);
        set.addIfUnknown(hints);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(set);
        return result;
    }

    private static Class<? extends I_Object> iAssignType(App app, String name, DebugInfo debug) {
        switch (name) {
            case "Break": {
                return JMo_Break.class;
            }
            case "Count": {
                return JMo_Count.class;
            }
            case "If": {
                return JMo_If.class;
            }
            case "IfNot": {
                return JMo_IfNot.class;
            }
            case "For": {
                return JMo_For.class;
            }
            case "Next": {
                return JMo_Next.class;
            }
            case "Repeat": {
                return JMo_Repeat.class;
            }
            case "Switch": {
                return JMo_Switch.class;
            }
            case "Try": {
                return JMo_Try.class;
            }
            case "While": {
                return JMo_While.class;
            }
            case "Group": {
                return JMo_Group.class;
            }
            case "Random": {
                return JMo_Random.class;
            }
            case "Range": {
                return JMo_Range.class;
            }
            case "Regex": {
                return JMo_Regex.class;
            }
            case "Timer": {
                app.strict.checkSave(debug, "Timer");
                return JMo_Timer.class;
            }
            case "Use": {
                return JMo_Use.class;
            }
            case "Date": {
                return JMo_Date.class;
            }
            case "DateTime": {
                return JMo_DateTime.class;
            }
            case "Time": {
                return JMo_Time.class;
            }
            case "Dir": {
                app.strict.checkSave(debug, "Dir");
                return JMo_Dir.class;
            }
            case "File": {
                app.strict.checkSave(debug, "File");
                return JMo_File.class;
            }
            case "Path": {
                app.strict.checkSave(debug, "Path");
                return JMo_Path.class;
            }
            case "PathList": {
                app.strict.checkSave(debug, "Path");
                return JMo_PathList.class;
            }
            case "RandomAccessFile": {
                app.strict.checkSave(debug, "RandomAccessFile");
                return JMo_RandomAccessFile.class;
            }
            case "FunctionMap": {
                return JMo_FunctionMap.class;
            }
            case "List": {
                return JMo_List.class;
            }
            case "Makro": {
                return JMo_Makro.class;
            }
            case "Map": {
                return JMo_Map.class;
            }
            case "KeyValue": {
                return JMo_KeyValue.class;
            }
            case "Tree": {
                return JMo_Tree.class;
            }
            case "TreeNode": {
                return JMo_TreeNode.class;
            }
            case "Table": {
                return JMo_Table.class;
            }
            case "Error": {
                return JMo_Error.class;
            }
            case "Cmd": {
                app.strict.checkSave(debug, "Cmd");
                return JMo_Cmd.class;
            }
            case "Input": {
                app.strict.checkSave(debug, "Input");
                return JMo_Input.class;
            }
            case "Sys": {
                return JMo_Sys.class;
            }
        }
        return null;
    }

    private static ErrorBaseDebug atomic(String type, DebugInfo debugInfo) {
        return new ParseError("Atomic types cannot created via typename!", type, debugInfo);
    }

    public static boolean isTypeKnown(CallRuntime cr, String type) {
        if (SearchArray.knows(ATOMIC.ATOMIC_TYPENAMES, type, true)) {
            return true;
        }
        if (SearchArray.knows(ATOMIC.ABSTRACT_TYPES, type, true)) {
            return true;
        }
        if (ObjectManager.getClass(type, cr.getApp().isDebug()) != null) {
            return true;
        }
        Type t = cr.getApp().getType().getType(type);
        if (t != null) {
            return true;
        }
        Class<?> c3 = ClassFinder.getInstance(cr.getApp().isDebug()).getJavaClass(type);
        return c3 != null;
    }
}

