/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.sys.MOut;
import java.util.HashMap;
import java.util.Map;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Parser;

public class FuncManager {
    private HashMap<String, Function> func;

    public void add(String name, Function f) {
        if (this.func == null) {
            this.func = new HashMap();
        }
        this.func.put(name, f);
    }

    public void describe(CallRuntime cr, int depth) {
        String space = Lib_Parser.space(depth);
        if (this.func != null) {
            for (Map.Entry<String, Function> g : this.func.entrySet()) {
                MOut.text(String.valueOf(space) + "::" + g.getKey());
                g.getValue().describe(cr, depth + 1);
            }
        }
    }

    public Function get(CallRuntime cr, String method) {
        char c0;
        if (this.func == null) {
            throw new CodeError(cr, "Unknown Function", "this." + method);
        }
        Function f = this.func.getOrDefault(method, null);
        if (f == null && cr.getStrict().isValid_AutoProperty() && (c0 = method.charAt(0)) >= 'a' && c0 <= 'z') {
            String m2 = "get" + Character.toUpperCase(c0) + method.substring(1);
            f = this.func.getOrDefault(m2, null);
        }
        if (f == null) {
            throw new CodeError(cr, "Unknown Function", String.valueOf(cr.getType().toString()) + "." + method);
        }
        return f;
    }

    public boolean knows(String name) {
        if (this.func == null) {
            return false;
        }
        String nameLow = name.toLowerCase();
        for (String key : this.func.keySet()) {
            if (!name.equals(key) && !nameLow.equals(key.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

