/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.struct;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.I_ObjectDebug;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Function;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;
import org.jmo_lang.tools.Lib_Prio;

public class Call
implements I_ObjectDebug {
    public final DebugInfo debugInfo;
    public final I_Object object;
    public final String method;
    public final byte prio;
    public final Call[] parCalls;
    public final Block surrounding;
    private Block ownBlock = null;
    private Call stream = null;

    public Call(Block surrBlock, I_Object obj, DebugInfo debugInfo) {
        this(surrBlock, obj, null, null, debugInfo);
    }

    public Call(Block surrBlock, I_Object obj, String met, Call[] pars, DebugInfo debugInfo) {
        if (met != null && met.length() == 0) {
            Err.invalid(met);
        }
        Err.ifNull(surrBlock);
        this.surrounding = surrBlock;
        this.object = obj;
        this.method = met;
        this.parCalls = pars;
        this.prio = (byte)(met == null || pars != null && pars.length != 1 ? 99 : (int)Lib_Prio.streamPrio(met, debugInfo));
        this.debugInfo = debugInfo;
    }

    public void describe(CallRuntime cr, int left) {
        String space = Lib_Parser.space(left);
        MOut.text(String.valueOf(space) + this.toDebug(cr));
        if (this.ownBlock != null) {
            this.ownBlock.describe(cr, left + 1);
        }
        if (this.stream != null) {
            this.stream.describe(cr, left);
        }
    }

    public Call searchLastCall() {
        if (this.method != null && Lib_Function.isVarFunction(this.method) > -1 && this.parCalls != null && this.parCalls.length > 0) {
            return this.parCalls[0].searchLastCall();
        }
        if (this.stream == null) {
            return this;
        }
        return this.stream.searchLastCall();
    }

    public int getParCount(CallRuntime cr) {
        return this.parCalls == null ? 0 : this.parCalls.length;
    }

    public void setBlock(Block b) {
        Err.ifNull(b);
        if (this.ownBlock != null) {
            Err.invalid(this.ownBlock, b);
        }
        this.ownBlock = b;
    }

    public Block getBlock() {
        return this.ownBlock;
    }

    public void setStream(Call c) {
        Err.ifNull(c);
        if (this.stream == null) {
            this.stream = c;
        } else {
            Err.invalid(this.toDebug(null), this.stream, c);
        }
    }

    public Call getStream() {
        return this.stream;
    }

    @Override
    public String toString() {
        String o = this.object == null ? "" : (this.object instanceof I_AtomicValue ? this.object.toDebug(null) : this.object.toString());
        boolean mathFunc = this.isMathematicFunction(this.method);
        String m = this.method == null ? "" : String.valueOf(mathFunc ? " " : ".") + this.method;
        String p = Lib_Output.toString(this.parCalls, true);
        if (p.length() != 0) {
            p = mathFunc ? " " + p : "(" + p + ")";
        }
        String a = this.ownBlock != null || this.stream != null ? "\u2026" : "";
        return String.valueOf(o) + m + p + a;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        String s;
        String o = this.object == null ? "" : this.object.toDebug(cr);
        boolean mathFunc = this.isMathematicFunction(this.method);
        String m = this.method == null ? "" : String.valueOf(mathFunc ? " " : ".") + this.method;
        String p = Lib_Output.toDebug(cr, this.parCalls);
        if (p.length() != 0) {
            p = mathFunc ? " " + p : "(" + p + ")";
        }
        String b = this.ownBlock == null ? "" : "{<Block>}";
        String string = s = this.stream == null ? "" : "\u2026";
        if (this.method == null && this.ownBlock == null && this.stream == null) {
            return String.valueOf(o) + p;
        }
        return String.valueOf(o) + m + p + b + s;
    }

    private boolean isMathematicFunction(String m) {
        if (m == null || m.length() == 0) {
            return false;
        }
        char c = m.charAt(0);
        return (c < 'a' || c > 'z') && c != '_' && c != '@';
    }
}

