/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.JMo_Byte;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.object.atom.JMo_Long;
import org.jmo_lang.object.atom.JMo_Short;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.Block;

public class ParseObj_Int
implements I_ParseObject {
    private static final String regex = "^([-+]?[0-9]+)[bsilfd]?.*$";

    @Override
    public boolean hits(char c0, Block current, String s) {
        return (c0 == '-' || c0 == '+' || c0 >= '0' && c0 <= '9') && s.matches(regex);
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        String nr = s.replaceFirst(regex, "$1");
        String rem = s.substring(nr.length());
        int typeChar = 105;
        A_Number obj = null;
        try {
            if (rem.length() == 0) {
                obj = new Int(Integer.parseInt(nr));
                return new Group2<I_Object, String>(obj, rem);
            }
            typeChar = rem.charAt(0);
            switch (typeChar) {
                case 98: {
                    obj = new JMo_Byte(Byte.parseByte(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 115: {
                    obj = new JMo_Short(Short.parseShort(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 105: {
                    obj = new Int(Integer.parseInt(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 108: {
                    obj = new JMo_Long(Long.parseLong(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 102: {
                    obj = new JMo_Float(Float.parseFloat(nr));
                    rem = rem.substring(1);
                    break;
                }
                case 100: {
                    obj = new Dec(Double.parseDouble(nr));
                    rem = rem.substring(1);
                    break;
                }
                default: {
                    obj = new Int(Integer.parseInt(nr));
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            int typeIdx = "bsilfd".indexOf(typeChar);
            String type = typeIdx == -1 ? "Int" : (new String[]{"Byte", "Short", "Int", "Long", "Float", "Dec"})[typeIdx];
            throw new ParseError("Invalid value for type.", "Value " + nr + " is out of range for type: " + type, parser.gDebugInfo());
        }
        return new Group2<I_Object, String>(obj, rem);
    }
}

