/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.JMo_Float;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.Block;

public class ParseObj_Dec
implements I_ParseObject {
    private static final String regex = "^([-]?[0-9]+([df]|\\.[0-9]+[df]?)).*$";

    @Override
    public boolean hits(char c0, Block current, String s) {
        return (c0 == '-' || c0 >= '0' && c0 <= '9') && s.matches(regex);
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        String nr = s.replaceFirst(regex, "$1");
        String rem = s.substring(nr.length());
        int len = nr.length();
        char last = nr.charAt(len - 1);
        try {
            switch (last) {
                case 'f': {
                    nr = nr.substring(0, len - 1);
                    float f = Float.parseFloat(nr);
                    return new Group2<I_Object, String>(new JMo_Float(f), rem);
                }
                case 'd': {
                    nr = nr.substring(0, len - 1);
                }
            }
            double d = Double.parseDouble(nr);
            return new Group2<I_Object, String>(new Dec(d), rem);
        }
        catch (NumberFormatException e) {
            throw new ParseError("Malformed number", String.valueOf(e.getMessage()) + " \"" + nr + '\"', parser.gDebugInfo());
        }
    }
}

