/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.sys.MOut;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.parser.Parser_Block;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.fdef.I_ParseFDef;
import org.jmo_lang.parser.fdef.ParseFDef_Direct;
import org.jmo_lang.parser.fdef.ParseFDef_ParMulti;
import org.jmo_lang.struct.Function;
import org.jmo_lang.struct.Type;
import org.jmo_lang.tools.ALLOWED;
import org.jmo_lang.tools.BLOCKED;

public class Parser_Function {
    private static final I_ParseFDef[] funcparser = new I_ParseFDef[]{new ParseFDef_Direct(), new ParseFDef_ParMulti()};

    public static void parse(Parser_Script parser, Type currentType, String s) {
        MOut.debug("Parse Function-Head", s);
        I_ParseFDef[] i_ParseFDefArray = funcparser;
        int n = funcparser.length;
        int n2 = 0;
        while (n2 < n) {
            I_ParseFDef pf = i_ParseFDefArray[n2];
            if (pf.hits(s)) {
                Function f = pf.parse(parser, currentType, s);
                String fName = f.getName();
                if (currentType.getFunctions().knows(fName)) {
                    throw new ParseError("Name of the function is already used!", "::" + fName, parser.gDebugInfo());
                }
                if (Lib_Array.knows(BLOCKED.FUNCTIONS, fName)) {
                    throw new ParseError("Invalid definition, name for Function reserved!", "::" + fName, parser.gDebugInfo());
                }
                String fNameLow = fName.toLowerCase();
                String[] stringArray = ALLOWED.overwriteFunctions;
                int n3 = ALLOWED.overwriteFunctions.length;
                int n4 = 0;
                while (n4 < n3) {
                    String owOk = stringArray[n4];
                    if (fNameLow.equals(owOk.toLowerCase()) && !fName.equals(owOk)) {
                        throw new ParseError("Invalid overwrite of a function", "Got \"" + fName + "\" but correct name is \"" + owOk + "\"", parser.gDebugInfo());
                    }
                    ++n4;
                }
                currentType.getFunctions().add(fName, f);
                if (parser.buffer.nextLevelDiff() > 0) {
                    if (f.isOneLine()) {
                        throw new ParseError("No Block allowed for one-line-function!", "::" + fName, parser.gDebugInfo());
                    }
                    new Parser_Block().parse(parser, currentType, f, f.getBlock(), false);
                }
                return;
            }
            ++n2;
        }
        throw new ParseError("Unknown Function-Definition", s, parser.gDebugInfo());
    }
}

