/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.parser;

import de.mn77.base.data.group.Group2;
import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ParseError;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.magic.var.A_MagicVar;
import org.jmo_lang.object.pseudo.MultiCall;
import org.jmo_lang.parser.Parser_Script;
import org.jmo_lang.parser.event.I_ParserEvStart;
import org.jmo_lang.parser.event.ParserEvStart_Args;
import org.jmo_lang.parser.event.ParserEvStart_Direct;
import org.jmo_lang.parser.func.I_ParseFunc;
import org.jmo_lang.parser.obj.I_ParseObject;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.tools.Lib_StringParser;

public class Parser_Call {
    private static int multiCallCounter = 0;
    private static final I_ParserEvStart[] parsers_EvStart = new I_ParserEvStart[]{new ParserEvStart_Direct(), new ParserEvStart_Args()};

    private Parser_Call() {
    }

    public static Call parseCall(Parser_Script parser, Block current, String s, boolean isArgument) {
        Group2<I_Object, String> go = Parser_Call.parseObject(parser, current, s, isArgument);
        I_Object obj = (I_Object)go.o1;
        s = (String)go.o2;
        s = Parser_Call.comment(s);
        Call first = null;
        Call last = null;
        while (s != null && s.length() > 0) {
            Call c = null;
            char c0 = s.charAt(0);
            s = s.trim();
            boolean dot = false;
            if (c0 == '.' && s.length() >= 2 && !s.startsWith("..")) {
                c0 = (s = s.substring(1)).charAt(0);
                if (c0 == ' ' || c0 == '\t') {
                    throw new CodeError("Space or tab after a dot", "Got: ." + s, parser.gDebugInfo());
                }
                dot = true;
            }
            if (c0 == '@') {
                c = Parser_Call.parseEvStart(parser, current, obj, s);
                s = "";
            } else {
                if (!(dot || (c0 < 'a' || c0 > 'z') && c0 != '_' || obj != null && obj instanceof A_MagicVar && ((A_MagicVar)obj).withoutDot())) {
                    throw new ParseError("Missing dot or mathematical sign.", s, parser.gDebugInfo());
                }
                Group2<Call, String> res = Parser_Call.parseMethod(parser, current, obj, s);
                c = (Call)res.o1;
                s = (String)res.o2;
            }
            if (first == null) {
                first = c;
            }
            if (last != null) {
                last.setStream(c);
            }
            last = c;
            obj = null;
            if (s == null || s.length() == 0) {
                Call last2 = c.searchLastCall();
                if (c.searchLastCall() != null) {
                    last = last2;
                }
            }
            if (s == null) continue;
            s = Parser_Call.comment(s);
        }
        if (first == null) {
            first = new Call(current, obj, parser.gDebugInfo());
        }
        return first;
    }

    public static Call parseCallMulti(Parser_Script parser, Block current, String s, int key) {
        Call c = Parser_Call.parseCall(parser, current, s, true);
        MultiCall mc = new MultiCall(key, c);
        return new Call(current, mc, parser.gDebugInfo());
    }

    public static Group2<I_Object, String> parseObject(Parser_Script parser, Block current, String s, boolean isArgument) {
        s = s.trim();
        I_ParseObject po = parser.app.parsemanager_obj.getParser(current, s, parser.gDebugInfo(), isArgument);
        return po.parse(parser, current, s);
    }

    public static Call[] parseParameter(Parser_Script parser, Block current, String s) {
        if (s.length() == 0) {
            return new Call[0];
        }
        s = s.trim();
        ArrayList<Call> pars = new ArrayList<Call>();
        while (s.length() > 0) {
            Group2<Call, String> g = Parser_Call.parseParameterItem(parser, current, s.trim());
            pars.add((Call)g.o1);
            s = (String)g.o2;
        }
        return pars.toArray(new Call[pars.size()]);
    }

    private static String comment(String s) {
        return (s = s.trim()).length() == 0 ? "" : (s.charAt(0) == '#' ? "" : s);
    }

    private static Call parseEvStart(Parser_Script parser, Block current, I_Object obj, String s) {
        I_ParserEvStart[] i_ParserEvStartArray = parsers_EvStart;
        int n = parsers_EvStart.length;
        int n2 = 0;
        while (n2 < n) {
            I_ParserEvStart pes = i_ParserEvStartArray[n2];
            if (pes.hits(s)) {
                return pes.parse(parser, current, obj, s);
            }
            ++n2;
        }
        throw new ParseError("Unknown Event-Start", s, parser.gDebugInfo());
    }

    private static Group2<Call, String> parseMethod(Parser_Script parser, Block current, I_Object obj, String s) {
        I_ParseFunc pf = parser.app.parsemanager_func.getParser(obj, s, parser.gDebugInfo());
        return pf.parse(parser, current, obj, s);
    }

    private static Group2<Call, String> parseParameterItem(Parser_Script parser, Block current, String s) {
        Group2<String, String> result = Lib_StringParser.getNextPar(s, parser.gDebugInfo());
        String par = (String)result.o1;
        String rem = (String)result.o2;
        int key = ++multiCallCounter;
        if (par.charAt(par.length() - 1) == '.') {
            if (!par.endsWith("...")) {
                throw new ParseError("Open end of argument", "Argument for functions ends with: " + s, parser.gDebugInfo());
            }
            par = par.substring(0, par.length() - 3);
            par = String.valueOf(par) + "\u00b6" + key;
            return new Group2<Call, String>(Parser_Call.parseCallMulti(parser, current, par, key), rem);
        }
        return new Group2<Call, String>(Parser_Call.parseCall(parser, current, par, true), rem);
    }
}

