/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.sys;

import java.util.Scanner;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;

public class JMo_Input
extends A_Object {
    private static Scanner sc = new Scanner(System.in);

    @Override
    public void init(CallRuntime cr) {
        cr.getStrict().checkWebstart(cr, "Input");
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "str": 
            case "readStr": {
                return A_Object.stdResult(this.getStr(cr));
            }
            case "int": 
            case "readInt": {
                return A_Object.stdResult(this.getInt(cr));
            }
            case "dec": 
            case "readDec": {
                return A_Object.stdResult(this.getDec(cr));
            }
        }
        return null;
    }

    public I_Atomic getDec(CallRuntime cr) {
        cr.pars();
        try {
            String s = sc.nextLine();
            s = s.replace(',', '.');
            double d = Double.parseDouble(s);
            return new Dec(d);
        }
        catch (NumberFormatException e) {
            return Nil.NIL;
        }
    }

    public I_Atomic getInt(CallRuntime cr) {
        cr.pars();
        try {
            String s = sc.nextLine();
            s = s.replace(',', '.');
            int i = Integer.parseInt(s);
            return new Int(i);
        }
        catch (NumberFormatException e) {
            return Nil.NIL;
        }
    }

    public Str getStr(CallRuntime cr) {
        cr.pars();
        String s = sc.nextLine();
        return new Str(s);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Input";
    }
}

