/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.sys;

import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.group.Group3;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.stream.UTF8OutputStream;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.cmd.SysCmd;
import de.mn77.base.sys.cmd.SysCmd_Data;
import java.io.IOException;
import java.util.ArrayList;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.error.ExtError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.object.struct.JMo_FunctionMap;
import org.jmo_lang.struct.ArgCallBuffer;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_Cmd
extends A_Object {
    private final ArgCallBuffer cmd;

    public JMo_Cmd(Call c) {
        this.cmd = new ArgCallBuffer(c);
    }

    @Override
    public void init(CallRuntime cr) {
        this.cmd.init(cr, this, Str.class);
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "live": {
                return A_Object.stdResult(this.live(cr));
            }
            case "exec": {
                return A_Object.stdResult(this.buffer(cr, false));
            }
            case "quiet": {
                return A_Object.stdResult(this.buffer(cr, true));
            }
            case "forget": {
                return A_Object.stdResult(this.forget(cr));
            }
            case "getStr": 
            case "pipe": {
                return A_Object.stdResult(this.pipe(cr));
            }
        }
        return null;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MOut.text(String.valueOf(Lib_Parser.space(left)) + this.toDebug(cr));
    }

    public JMo_FunctionMap buffer(CallRuntime cr, boolean quiet) {
        cr.pars();
        Group3<SysCmd_Data, UTF8OutputStream, UTF8OutputStream> res = this.run(cr, true, INOUT.BUFFER);
        String output = FilterText.removeTrailingFF(((UTF8OutputStream)res.o2).getString());
        String errors = FilterText.removeTrailingFF(((UTF8OutputStream)res.o3).getString());
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<I_Object> objects = new ArrayList<I_Object>();
        names.add("result");
        objects.add(new Int(((SysCmd_Data)res.o1).result.get()));
        names.add("output");
        objects.add(new Str(output));
        names.add("errors");
        objects.add(new Str(errors));
        JMo_FunctionMap with = new JMo_FunctionMap(cr, names, objects);
        if (!quiet) {
            Lib_Output.out(cr.getApp(), output, true);
        }
        return with;
    }

    public I_Object live(CallRuntime cr) {
        cr.pars();
        Group3<SysCmd_Data, UTF8OutputStream, UTF8OutputStream> res = this.run(cr, true, INOUT.LIVE);
        return new Int(((SysCmd_Data)res.o1).result.get());
    }

    public Nil forget(CallRuntime cr) {
        cr.pars();
        this.run(cr, false, INOUT.NONE);
        return Nil.NIL;
    }

    private I_Object pipe(CallRuntime cr) {
        cr.pars();
        Group3<SysCmd_Data, UTF8OutputStream, UTF8OutputStream> res = this.run(cr, true, INOUT.BUFFER);
        if (((SysCmd_Data)res.o1).result.get() != 0) {
            throw new ExecError(cr, "System-command terminated with an error", "The command \"" + ((SysCmd_Data)res.o1).command.get() + "\" ended with exit code: " + ((SysCmd_Data)res.o1).result.get());
        }
        String output = FilterText.removeTrailingFF(((UTF8OutputStream)res.o2).getString());
        String errors = FilterText.removeTrailingFF(((UTF8OutputStream)res.o3).getString());
        if (errors != null && errors.length() > 0) {
            Lib_Output.out(cr.getApp(), errors, true);
        }
        return new Str(output);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "Command(\"" + this.toString() + "\")";
    }

    @Override
    public String toString() {
        return "Cmd(" + this.cmd.toString() + ")";
    }

    private Group3<SysCmd_Data, UTF8OutputStream, UTF8OutputStream> run(CallRuntime cr, boolean wait, INOUT io) {
        String cs = ((Str)this.cmd.get()).getValue();
        SysCmd_Data data = new SysCmd_Data();
        data.command.set(cs);
        data.wait.set(wait);
        UTF8OutputStream streamOutput = null;
        UTF8OutputStream streamError = null;
        try {
            if (io == INOUT.BUFFER) {
                streamOutput = new UTF8OutputStream();
                data.streamOutput.set(streamOutput);
                streamError = new UTF8OutputStream();
                data.streamError.set(streamError);
            }
            if (wait && io == INOUT.LIVE) {
                data.streamOutput.set(System.out);
                data.streamError.set(System.err);
                data.streamInput.set(System.in);
            }
            try {
                SysCmd cmd = new SysCmd();
                cmd.start(data);
            }
            catch (Err_Exception f) {
                throw new ExecError(cr, "Command execution error", f.getMessage());
            }
            Group3<SysCmd_Data, UTF8OutputStream, UTF8OutputStream> group3 = new Group3<SysCmd_Data, UTF8OutputStream, UTF8OutputStream>(data, streamOutput, streamError);
            return group3;
        }
        catch (Err_Runtime e) {
            Group3<SysCmd_Data, UTF8OutputStream, Object> group3 = new Group3<SysCmd_Data, UTF8OutputStream, Object>(data, streamOutput, streamError);
            return group3;
        }
        catch (Exception e) {
            throw new ExtError(cr, "Command execution error", e.getMessage());
        }
        finally {
            if (io == INOUT.BUFFER) {
                try {
                    if (streamOutput != null) {
                        streamOutput.close();
                    }
                    if (streamError != null) {
                        streamError.close();
                    }
                }
                catch (IOException e) {
                    Err.show(e);
                }
            }
        }
    }

    private static enum INOUT {
        NONE,
        BUFFER,
        LIVE;

    }
}

