/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.struct;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.List;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.struct.A_Sequence;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Output;
import org.jmo_lang.tools.Lib_Parser;

public class JMo_TreeNode
extends A_Sequence {
    protected final ArrayList<JMo_TreeNode> nodes = new ArrayList();
    private I_Atomic name = null;
    private I_Object value = null;

    public JMo_TreeNode(I_Atomic name) {
        this.name = name;
    }

    public JMo_TreeNode(I_Atomic name, I_Object value) {
        Err.ifNull(name);
        this.name = name;
        this.value = value;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        MList<String> target = new MList<String>();
        for (JMo_TreeNode node : this.nodes) {
            node.describe(cr, target, left);
        }
        for (String s : target) {
            Lib_Output.out(cr.getApp(), s, true);
        }
    }

    public void describe(CallRuntime cr, I_List<String> target, int left) {
        target.add(String.valueOf(Lib_Parser.space(left)) + this.toString());
        for (JMo_TreeNode node : this.nodes) {
            node.describe(cr, target, left + 1);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.name == null ? "Tree" : this.name.toString()) + (this.value == null ? "" : ": " + this.value.toString());
    }

    public Group2<I_Atomic, I_Object> internalNameValue() {
        return new Group2<I_Atomic, I_Object>(this.name, this.value);
    }

    public List<JMo_TreeNode> internalNodes() {
        return this.nodes;
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getName": {
                return A_Object.stdResult(this.getName(cr));
            }
            case "setName": {
                return A_Object.stdResult(this.setName(cr));
            }
            case "getValue": {
                return A_Object.stdResult(this.getValue(cr));
            }
            case "setValue": {
                return A_Object.stdResult(this.setValue(cr));
            }
            case "addNode": 
            case "+": 
            case "add": {
                return A_Object.stdResult(this.add(cr));
            }
            case "addNodes": {
                return A_Object.stdResult(this.addNodes(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.removeNodes(cr));
            }
            case "remove": 
            case "removeNames": 
            case "--": {
                return A_Object.stdResult(this.removeNames(cr));
            }
            case "removeValues": {
                return A_Object.stdResult(this.removeValues(cr));
            }
            case "show": {
                cr.pars();
                this.describe(cr, 0);
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    @Override
    protected I_Object first(CallRuntime cr) {
        return this.nodes.size() == 0 ? Nil.NIL : (I_Object)this.nodes.get(0);
    }

    @Override
    protected I_Object last(CallRuntime cr) {
        return this.nodes.size() == 0 ? Nil.NIL : (I_Object)this.nodes.get(this.nodes.size() - 1);
    }

    @Override
    protected int sequenceSize() {
        return this.nodes.size();
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.nodes.size() == 0;
    }

    @Override
    protected I_Object sequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 1);
        if (pars.length > 1) {
            return this.sequenceDeepGet(cr, pars, 0, lazy);
        }
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(pars[0])) continue;
            return node;
        }
        if (lazy) {
            A_Atomic apar = (A_Atomic)cr.parType(pars[0], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            return node;
        }
        throw new ExecError(cr, "Node not found", "Can't find node with name: " + pars[0].toString());
    }

    @Override
    protected void sequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] pars = cr.parsVarArgs(this, 2, 1);
        I_Object newValue = pars[0];
        if (pars.length > 2) {
            this.sequenceDeepSet(cr, pars, 1, newValue, lazy);
            return;
        }
        JMo_TreeNode found = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(pars[1])) continue;
            found = node;
        }
        if (lazy && found == null) {
            A_Atomic apar = (A_Atomic)cr.parType(pars[1], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            found = node;
        }
        if (found == null) {
            throw new ExecError(cr, "Node not found", "Can't find node with name: " + pars[0].toString());
        }
        found.value = newValue;
    }

    @Override
    protected A_Sequence copy(CallRuntime cr) {
        Err.todo(cr);
        return null;
    }

    @Override
    protected JMo_List sequenceSelect(CallRuntime cr, boolean lazy) {
        Err.todo(cr);
        return null;
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        JMo_TreeNode result = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(keys[offset])) continue;
            result = node;
            break;
        }
        if (lazy && result == null) {
            A_Atomic apar = (A_Atomic)cr.parType(keys[offset], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            result = node;
        }
        if (result == null) {
            throw new ExecError(cr, "Node not found", "Can't find node with name: " + keys[0].toString());
        }
        if (keys.length - offset == 1) {
            return result;
        }
        return result.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        if (keys.length - offset == 0) {
            this.value = value;
            return;
        }
        JMo_TreeNode found = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(keys[offset])) continue;
            found = node;
        }
        if (lazy && found == null) {
            A_Atomic apar = (A_Atomic)cr.parType(keys[offset], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            found = node;
        }
        if (found == null) {
            throw new ExecError(cr, "Node not found", "Can't find node with name: " + keys[offset].toString());
        }
        found.sequenceDeepSet(cr, keys, offset + 1, value, lazy);
    }

    private JMo_TreeNode setName(CallRuntime cr) {
        if (this.name == null) {
            throw new ExecError(cr, "Invalid name for root element", "Can't set value for root of the tree");
        }
        this.name = (A_Atomic)cr.pars(this, A_Atomic.class)[0];
        return this;
    }

    private I_Object getName(CallRuntime cr) {
        cr.pars();
        return this.name == null ? Nil.NIL : this.name;
    }

    private JMo_TreeNode setValue(CallRuntime cr) {
        if (this.name == null) {
            throw new ExecError(cr, "Invalid value for root element", "Can't set value for root of the tree");
        }
        this.value = cr.pars(this, I_Object.class)[0];
        return this;
    }

    private I_Object getValue(CallRuntime cr) {
        cr.pars();
        return this.value == null ? Nil.NIL : this.value;
    }

    private JMo_TreeNode add(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(this, 1, 2);
        I_Object key_node = pars[0];
        int len = pars.length;
        if (len == 1 && key_node instanceof JMo_TreeNode) {
            this.nodes.add((JMo_TreeNode)key_node);
            return (JMo_TreeNode)key_node;
        }
        A_Atomic aPar = (A_Atomic)cr.parType(key_node, A_Atomic.class);
        JMo_TreeNode result = len == 1 ? new JMo_TreeNode(aPar) : new JMo_TreeNode(aPar, pars[1]);
        this.nodes.add(result);
        return result;
    }

    private JMo_TreeNode addNodes(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsVarArgs(this, 0, 0);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            if (par instanceof JMo_TreeNode) {
                this.nodes.add((JMo_TreeNode)par);
            } else {
                A_Atomic aPar = (A_Atomic)cr.parType(par, A_Atomic.class);
                this.nodes.add(new JMo_TreeNode(aPar));
            }
            ++n2;
        }
        return this;
    }

    private I_Object removeNodes(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsVarArgs(this, 1, 0);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            boolean removed = false;
            int i = 0;
            while (i < this.nodes.size()) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.name.equals(par)) {
                    this.nodes.remove(i);
                    removed = true;
                    break;
                }
                ++i;
            }
            if (!removed) {
                throw new ExecError(cr, "Node not found", "Can't find node with name: " + par.toString());
            }
            ++n2;
        }
        return this;
    }

    private JMo_TreeNode removeNames(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsVarArgs(this, 1, 0);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            int i = 0;
            while (i < this.nodes.size()) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.value != null && node.value.equals(par)) {
                    this.nodes.remove(i);
                } else {
                    node.deepNameRemove(par);
                }
                ++i;
            }
            ++n2;
        }
        return this;
    }

    private void deepNameRemove(I_Object toRemove) {
        int i = 0;
        while (i < this.nodes.size()) {
            JMo_TreeNode node = this.nodes.get(i);
            if (node.name.equals(toRemove)) {
                this.nodes.remove(i);
            } else {
                node.deepNameRemove(toRemove);
            }
            ++i;
        }
    }

    private JMo_TreeNode removeValues(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsVarArgs(this, 1, 0);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            int i = 0;
            while (i < this.nodes.size()) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.value != null && node.value.equals(par)) {
                    this.nodes.remove(i);
                } else {
                    node.deepValueRemove(par);
                }
                ++i;
            }
            ++n2;
        }
        return this;
    }

    private void deepValueRemove(I_Object toRemove) {
        int i = 0;
        while (i < this.nodes.size()) {
            JMo_TreeNode node = this.nodes.get(i);
            if (node.value != null && node.value.equals(toRemove)) {
                this.nodes.remove(i);
            } else {
                node.deepValueRemove(toRemove);
            }
            ++i;
        }
    }
}

