/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.passthrough;

import de.mn77.base.error.Err;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.passthrough.I_PassThrough;
import org.jmo_lang.object.passthrough.I_VarConst;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Function;

public class Const
extends A_Object
implements I_PassThrough,
I_VarConst {
    private final String name;
    private final boolean nilable;
    private String initType = null;

    public Const(String name) {
        Err.ifNull(name);
        this.name = name;
        this.nilable = name.endsWith("?");
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "=": 
            case "let": {
                I_Object streamit = cr.vce.cons.get(cr, this, null);
                I_Object par = cr.pars(streamit, I_Object.class)[0];
                this.set(cr, cr, par);
                return new ObjectCallResult(this, false);
            }
        }
        if (Lib_Function.isVarFunction(method) > -1) {
            throw new CodeError(cr, "Invalid method for constant", "Can't change the once assigned value of a constant with: " + method);
        }
        return this.get(cr).call(cr);
    }

    public I_Object get(CallRuntime cr) {
        return cr.vce.cons.get(cr, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(String type, DebugInfo debugInfo) {
        this.initType = type;
    }

    public void set(CallRuntime cpOld, CallRuntime cpNew, I_Object o) {
        if (this.initType != null) {
            cpNew.vce.cons.setType(cpNew, this, this.initType);
            this.initType = null;
        }
        cpNew.vce.cons.set(cpOld, this, o, true, this.nilable, false);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        String val = cr.vce.cons.toDebug(cr, this, "");
        return String.valueOf(this.name) + "(" + val + ")";
    }

    @Override
    public String toString() {
        return this.name;
    }
}

