/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.constant.position.Lib_Position;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.convert.ConvChar;
import de.mn77.base.data.convert.ConvText;
import de.mn77.base.data.filter.FilterText;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.search.SearchText;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.error.Err;
import de.mn77.spec.numbersys.Hex;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.Handle_Loop;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Regex;
import org.jmo_lang.object.atom.A_Chars;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.magic.con.MagicPosition;
import org.jmo_lang.object.pseudo.Return;
import org.jmo_lang.object.struct.I_DeepGetSet;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.object.struct.JMo_Table;
import org.jmo_lang.object.sys.JMo_Cmd;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.I_AutoBlockDo;
import org.jmo_lang.struct.I_AutoBlockList;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.BlockExecArgs;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;
import org.jmo_lang.tools.Lib_Exec;
import org.jmo_lang.tools.Lib_Sequence;
import org.jmo_lang.tools.Lib_StrFormat;
import org.jmo_lang.tools.Lib_Type;

public class Str
extends A_Chars
implements I_Atomic,
I_AutoBlockDo,
I_AutoBlockList,
I_DeepGetSet {
    private final String value;

    public Str(String val) {
        Err.ifNull(val);
        this.value = val;
    }

    @Override
    protected ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.sub(cr));
            }
            case "begin": {
                return A_Object.stdResult(this.begin(cr));
            }
            case "cut": {
                return A_Object.stdResult(this.cut(cr));
            }
            case "area": 
            case "cutTo": {
                return A_Object.stdResult(this.cutTo(cr));
            }
            case "left": {
                return A_Object.stdResult(this.left(cr));
            }
            case "right": {
                return A_Object.stdResult(this.right(cr));
            }
            case "first": {
                return A_Object.stdResult(this.firstLast(cr, false));
            }
            case "last": {
                return A_Object.stdResult(this.firstLast(cr, true));
            }
            case "end": {
                return A_Object.stdResult(this.endPos(cr));
            }
            case "start": {
                return A_Object.stdResult(this.startPos(cr));
            }
            case "from": 
            case "fromFirst": {
                return A_Object.stdResult(this.fromFirst(cr, true));
            }
            case "after": 
            case "afterFirst": {
                return A_Object.stdResult(this.fromFirst(cr, false));
            }
            case "toFirst": 
            case "to": {
                return A_Object.stdResult(this.toFirst(cr, true));
            }
            case "before": 
            case "beforeFirst": {
                return A_Object.stdResult(this.toFirst(cr, false));
            }
            case "fromLast": {
                return A_Object.stdResult(this.fromLast(cr, true));
            }
            case "afterLast": {
                return A_Object.stdResult(this.fromLast(cr, false));
            }
            case "toLast": {
                return A_Object.stdResult(this.toLast(cr, true));
            }
            case "beforeLast": {
                return A_Object.stdResult(this.toLast(cr, false));
            }
            case "explode": 
            case "/": 
            case "split": {
                return A_Object.stdResult(this.split(cr));
            }
            case "splitKeep": {
                return A_Object.stdResult(this.splitKeep(cr));
            }
            case "lines": {
                return A_Object.stdResult(this.lines(cr));
            }
            case "field": {
                return A_Object.stdResult(this.field(cr));
            }
            case "fields": {
                return A_Object.stdResult(this.fields(cr));
            }
            case "table": {
                return A_Object.stdResult(this.table(cr));
            }
            case "capitalize": 
            case "capital": {
                return A_Object.stdResult(this.capital(cr));
            }
            case "trim": {
                return A_Object.stdResult(this.trim(cr, true, true));
            }
            case "trimLeft": {
                return A_Object.stdResult(this.trim(cr, true, false));
            }
            case "trimRight": {
                return A_Object.stdResult(this.trim(cr, false, true));
            }
            case "startsWith": {
                return A_Object.stdResult(this.startsWith(cr));
            }
            case "contains": 
            case "has": {
                return A_Object.stdResult(this.has(cr));
            }
            case "endsWith": {
                return A_Object.stdResult(this.endsWith(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.search(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.search(cr, false));
            }
            case "count": {
                return A_Object.stdResult(this.count(cr));
            }
            case "replace": {
                return A_Object.stdResult(this.replace(cr));
            }
            case "match": {
                return A_Object.stdResult(this.match(cr));
            }
            case "set": {
                return A_Object.stdResult(this.setChar(cr, false));
            }
            case "put": {
                return A_Object.stdResult(this.setChar(cr, true));
            }
            case "align": {
                return A_Object.stdResult(this.align(cr));
            }
            case "fill": {
                return A_Object.stdResult(this.fill(cr));
            }
            case "quote": {
                return A_Object.stdResult(this.quote(cr));
            }
            case "unquote": {
                return A_Object.stdResult(this.unquote(cr));
            }
            case "jmo": {
                return A_Object.stdResult(this.exec_jmo(cr));
            }
            case "cmd": {
                return A_Object.stdResult(this.exec_cmd(cr));
            }
            case "fromHex": 
            case "hexToInt": {
                return A_Object.stdResult(this.hexToInt(cr));
            }
            case "fromUnicode": {
                return A_Object.stdResult(this.fromUnicode(cr));
            }
            case "toChars": 
            case "chars": {
                return A_Object.stdResult(this.chars(cr));
            }
            case "each": {
                return this.each(cr);
            }
            case "filter": {
                return A_Object.stdResult(this.filter(cr, method));
            }
            case "map": {
                return A_Object.stdResult(this.map(cr, method));
            }
            case "sort": {
                return A_Object.stdResult(this.sort(cr, method));
            }
            case "reduce": {
                return A_Object.stdResult(this.reduce(cr, method));
            }
            case "amount": {
                return A_Object.stdResult(this.amount(cr, method));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            result.add(new Char(c));
            ++n2;
        }
        return result;
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof Str) {
            return this.value.compareTo(((Str)o).getValue());
        }
        return null;
    }

    private ObjectCallResult each(CallRuntime cpOld) {
        I_Object[] pars = cpOld.parsFlex(this, 0, 1);
        Lib_Exec.checkLoopWithout(cpOld, pars);
        Handle_Loop handle = new Handle_Loop(this);
        CallRuntime cpNew = cpOld.copyLoop(handle);
        BlockExecArgs args = new BlockExecArgs(pars);
        I_Object result = Nil.NIL;
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            handle.startLap();
            Char it = new Char(c);
            result = Lib_Exec.execBlockStream(cpNew, args, it);
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++n2;
        }
        return new ObjectCallResult(result, true);
    }

    private Str filter(CallRuntime cr, String method) {
        Lib_Error.ifPars(cr.parCount(), 1, 2, cr);
        StringBuilder result = new StringBuilder();
        int p = 0;
        while (p < this.value.length()) {
            char test = this.value.charAt(p);
            Char testc = new Char(test);
            Bool ok = (Bool)cr.copyEach(method).parsEach(this, 0, new I_Object[]{testc}, Bool.class);
            if (ok.getValue().booleanValue()) {
                result.append(test);
            }
            ++p;
        }
        return new Str(result.toString());
    }

    private Str map(CallRuntime cr, String method) {
        Lib_Error.ifPars(cr.parCount(), 1, 2, cr);
        StringBuilder result = new StringBuilder();
        int p = 0;
        while (p < this.value.length()) {
            Char test = new Char(this.value.charAt(p));
            I_Object[] each = new I_Object[]{test};
            I_Object testr = cr.copyEach(method).parsEach(this, 0, each, I_Object.class);
            result.append(testr);
            ++p;
        }
        return new Str(result.toString());
    }

    private I_Object reduce(CallRuntime cr, String method) {
        Lib_Error.ifPars(cr.parCount(), 2, 3, cr);
        I_Object sum = cr.parsOneAdvance(this, 0, I_Object.class);
        int p = 0;
        while (p < this.value.length()) {
            Char test = new Char(this.value.charAt(p));
            I_Object[] each = new I_Object[]{sum, test};
            sum = cr.copyEach(method).parsEach(this, 1, each, I_Object.class);
            ++p;
        }
        return sum;
    }

    private Int amount(CallRuntime cr, String method) {
        Lib_Error.ifPars(cr.parCount(), 1, 2, cr);
        int result = 0;
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char test = cArray[n2];
            Bool ok = (Bool)cr.copyEach(method).parsEach(this, 0, new I_Object[]{new Char(test)}, Bool.class);
            if (ok.getValue().booleanValue()) {
                ++result;
            }
            ++n2;
        }
        return new Int(result);
    }

    private Str sort(CallRuntime cr, String method) {
        int parCount = cr.parCount();
        Lib_Error.ifPars(parCount, 0, 2, cr);
        ArrayList<Character> list = new ArrayList<Character>();
        Object object = this.value.toCharArray();
        int n = ((char[])object).length;
        int n2 = 0;
        while (n2 < n) {
            char c = object[n2];
            list.add(Character.valueOf(c));
            ++n2;
        }
        if (parCount == 0) {
            cr.pars();
            list.sort((o1, o2) -> Lib_Compare.isEqual(o1, o2) ? 0 : (Lib_Compare.isGreater(o1, o2) ? 1 : -1));
            StringBuilder sb = new StringBuilder();
            for (Character c : list) {
                sb.append(c);
            }
            return new Str(sb.toString());
        }
        int l = 1;
        while (l < list.size()) {
            int smallest = l;
            int m = l + 1;
            while (m <= list.size()) {
                Character buffer1 = (Character)list.get(smallest - 1);
                Character buffer2 = (Character)list.get(m - 1);
                I_Object[] test = new I_Object[]{new Char(buffer1.charValue()), new Char(buffer2.charValue())};
                Bool correct = (Bool)cr.copyEach(method).parsEach(this, 0, test, Bool.class);
                if (!correct.getValue().booleanValue()) {
                    smallest = m;
                }
                ++m;
            }
            if (l != smallest) {
                int pos1 = smallest - 1;
                int pos2 = l - 1;
                Character buffer1 = (Character)list.get(pos1);
                Character buffer2 = (Character)list.get(pos2);
                list.set(pos1, buffer2);
                list.set(pos2, buffer1);
            }
            ++l;
        }
        StringBuilder sb = new StringBuilder();
        object = list.iterator();
        while (object.hasNext()) {
            Character c = (Character)object.next();
            sb.append(c);
        }
        return new Str(sb.toString());
    }

    private JMo_List chars(CallRuntime cr) {
        cr.pars();
        char[] ca = this.value.toCharArray();
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        char[] cArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            al.add(new Char(c));
            ++n2;
        }
        return new JMo_List(al);
    }

    private Str fill(CallRuntime cr) {
        I_Object[] oa = cr.parsVarArgs(this, 0, 0);
        int oaPos = 0;
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (pos < this.value.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(this.value, pos);
            pos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue() || oaPos >= oa.length) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, oa[oaPos++]));
        }
        return new Str(sb.toString());
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.STR, to, this, this.getValue());
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "\"" + this.value + "\"";
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    protected Bool comparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.pars(this, A_Chars.class)[0];
        String par = Lib_Convert.getStringValue(cr, o);
        switch (m) {
            case G: {
                return Bool.getObject(this.value.compareTo(par) > 0);
            }
            case L: {
                return Bool.getObject(this.value.compareTo(par) < 0);
            }
            case GE: {
                return Bool.getObject(this.value.compareTo(par) >= 0);
            }
            case LE: {
                return Bool.getObject(this.value.compareTo(par) <= 0);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected Str add(CallRuntime cr) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 0);
        String result = this.value;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            result = String.valueOf(result) + Lib_Convert.getStringValue(cr, par);
            ++n2;
        }
        return new Str(result);
    }

    private Str begin(CallRuntime cr) {
        I_Object par = cr.pars(this, I_Object.class)[0];
        String ps = Lib_Convert.getStringValue(cr, par);
        return new Str(String.valueOf(ps) + this.value);
    }

    private Str align(CallRuntime cr) {
        I_Object[] pars = cr.pars(this, MagicPosition.class, A_IntNumber.class);
        int par = Lib_Convert.getIntValue(cr, pars[1]);
        MagicPosition pos1 = (MagicPosition)Lib_Convert.getValue(cr, pars[0]);
        POSITION pos2 = pos1.get();
        if (!Lib_Position.isHorizontal(pos2)) {
            throw new ExecError(cr, "Invalid position", "Only left,center and right are alowed. Got: " + pos1);
        }
        String s = FormString.width(par, ' ', this.value, (POSITION_H)((Object)pos2), false);
        return new Str(s);
    }

    private Str capital(CallRuntime cr) {
        cr.pars();
        String s = this.value.toLowerCase();
        String result = "";
        if (s.length() > 0) {
            result = ("" + s.charAt(0)).toUpperCase();
        }
        if (s.length() > 1) {
            result = String.valueOf(result) + s.substring(1);
        }
        return new Str(result);
    }

    @Override
    protected Str caseDown(CallRuntime cr) {
        cr.pars();
        return new Str(this.value.toLowerCase());
    }

    @Override
    protected Str caseUp(CallRuntime cr) {
        cr.pars();
        return new Str(this.value.toUpperCase());
    }

    @Override
    protected I_Object charAt(CallRuntime cr, boolean lazy) {
        int pos = Lib_Convert.getIntValue(cr, cr.pars(this, A_IntNumber.class)[0]);
        pos = Lib_Sequence.realPos(cr, pos, this.value.length(), lazy);
        if (lazy && (pos < 1 || pos > this.value.length())) {
            return Nil.NIL;
        }
        return new Char(this.value.charAt(pos - 1));
    }

    private Str field(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, I_AtomicValue.class, A_IntNumber.class);
        String delimiter = Lib_Convert.getStringValue(cr, oa[0]);
        String[] sa = this.value.split(delimiter);
        int col = Lib_Convert.getIntValue(cr, oa[1]);
        Lib_Error.ifTooSmall(cr, 1L, col);
        return col > sa.length ? new Str("") : new Str(sa[col - 1]);
    }

    private JMo_List fields(CallRuntime cr) {
        I_Object[] oa = cr.parsVarArgs(this, 1, 1);
        I_Object parDelimiter = cr.parType(oa[0], I_AtomicValue.class);
        String delimiter = Lib_Convert.getStringValue(cr, parDelimiter);
        String[] sa = this.value.split(delimiter);
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        if (oa.length == 1) {
            String[] stringArray = sa;
            int n = sa.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                al.add(new Str(s));
                ++n2;
            }
        } else {
            int i = 1;
            while (i < oa.length) {
                int col = Lib_Convert.getIntValue(cr, oa[i]);
                Lib_Error.ifTooSmall(cr, 1L, col);
                Str s = col > sa.length ? new Str("") : new Str(sa[col - 1]);
                al.add(s);
                ++i;
            }
        }
        return new JMo_List(al);
    }

    private JMo_Table table(CallRuntime cr) {
        I_Object par = cr.pars(this, I_AtomicValue.class)[0];
        String delimiter = Lib_Convert.getStringValue(cr, par);
        String[] lines = this.value.split("\n");
        int len = lines.length;
        String[][] splitLines = new String[len][0];
        int i = 0;
        while (i < len) {
            splitLines[i] = ConvText.toStringArray(delimiter, lines[i]);
            ++i;
        }
        int max_width = 1;
        int i2 = 0;
        while (i2 < len) {
            max_width = Math.max(splitLines[i2].length, max_width);
            ++i2;
        }
        MTable<I_Object> tab = new MTable<I_Object>(max_width);
        int r = 0;
        while (r < len) {
            I_Object[] row = new I_Object[max_width];
            int c = 0;
            while (c < max_width) {
                row[c] = splitLines[r].length - 1 >= c ? new Str(splitLines[r][c]) : new Str("");
                ++c;
            }
            tab.add((I_Object[])row);
            ++r;
        }
        return new JMo_Table(tab);
    }

    private Str cut(CallRuntime cr) {
        I_Object[] pars = cr.pars(this, A_IntNumber.class, A_IntNumber.class);
        int from = Lib_Convert.getIntValue(cr, pars[0]);
        int len = Lib_Convert.getIntValue(cr, pars[1]);
        Lib_Error.ifNotBetween(cr, 1, this.value.length(), from, "'from'");
        Lib_Error.ifNotBetween(cr, 0, this.value.length() - from + 1, len, "'length'");
        int to = from + len;
        String s = this.value.substring(from - 1, to - 1);
        return new Str(s);
    }

    private Str cutTo(CallRuntime cr) {
        I_Object[] pars = cr.pars(this, A_IntNumber.class, A_IntNumber.class);
        int from = Lib_Convert.getIntValue(cr, pars[0]);
        int to = Lib_Convert.getIntValue(cr, pars[1]);
        Lib_Error.ifNotBetween(cr, 1, this.value.length(), from, "'from'");
        Lib_Error.ifNotBetween(cr, from, this.value.length(), to, "'length'");
        String s = this.value.substring(from - 1, to);
        return new Str(s);
    }

    private Bool endsWith(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsVarArgs(this, 1, 0);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            String s = Lib_Convert.getStringValue(cr, cr.parType(o, I_AtomicValue.class));
            if (this.value.endsWith(s)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private I_Object exec_cmd(CallRuntime cr) {
        cr.pars();
        cr.getStrict().checkSave(cr, "Str.command");
        Call c = new Call(cr.getSurrBlock(), this, cr.getDebugInfo());
        return new JMo_Cmd(c);
    }

    private Str exec_jmo(CallRuntime cr) {
        cr.pars();
        return Lib_Exec.execJMo(cr, this.value, "String.jmo", false);
    }

    private Str startPos(CallRuntime cr) {
        I_Object par = cr.pars(this, A_IntNumber.class)[0];
        int begin = Lib_Convert.getIntValue(cr, par);
        if (begin == 0) {
            throw new ExecError(cr, "Invalid position in string", "Position can't be 0");
        }
        if (begin < 0) {
            begin = this.value.length() + begin + 1;
        }
        if (begin < 1 || begin > this.value.length()) {
            return new Str("");
        }
        String s = this.value.substring(begin - 1);
        return new Str(s);
    }

    private Str fromFirst(CallRuntime cr, boolean withDelimiter) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 0);
        int idx = -1;
        String lastDelimiter = null;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, par);
            int idx2 = this.value.indexOf(delimiter);
            if (idx2 > -1 && (idx == -1 || idx2 < idx)) {
                idx = idx2;
                lastDelimiter = delimiter;
            }
            ++n2;
        }
        String result = idx >= 0 ? this.value.substring(idx + (withDelimiter ? 0 : lastDelimiter.length())) : "";
        return new Str(result);
    }

    private Str fromLast(CallRuntime cr, boolean withDelimiter) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 0);
        int beginindex = -1;
        String lastDelimiter = null;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, par);
            int idx2 = this.value.lastIndexOf(delimiter);
            if (idx2 > -1 && (beginindex == -1 || idx2 > beginindex)) {
                beginindex = idx2;
                lastDelimiter = delimiter;
            }
            ++n2;
        }
        String result = beginindex >= 0 ? this.value.substring(beginindex + (withDelimiter ? 0 : lastDelimiter.length())) : "";
        return new Str(result);
    }

    private Bool has(CallRuntime cr) {
        I_AtomicValue par = (I_AtomicValue)cr.pars(this, I_AtomicValue.class)[0];
        int index = this.value.indexOf(Lib_Convert.getStringValue(cr, par));
        return Bool.getObject(index > -1);
    }

    private Int hexToInt(CallRuntime cr) {
        cr.pars();
        int i = Hex.fromHex(this.value);
        return new Int(i);
    }

    private Char fromUnicode(CallRuntime cr) {
        cr.pars();
        char c = ConvChar.fromUnicode(this.value);
        return new Char(c);
    }

    private Str left(CallRuntime cr) {
        I_Object par = cr.pars(this, A_IntNumber.class)[0];
        int to = Lib_Convert.getIntValue(cr, par);
        if (to > this.value.length()) {
            return this;
        }
        Lib_Error.ifTooSmall(cr, 1L, to);
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private Char firstLast(CallRuntime cr, boolean last) {
        cr.pars();
        if (this.value.length() == 0) {
            throw new ExecError(cr, "Empty String", "Can't get first or last Char.");
        }
        return new Char(this.value.charAt(last ? this.value.length() - 1 : 0));
    }

    private JMo_List lines(CallRuntime cr) {
        cr.pars(this, new Class[0]);
        String[] sa = this.value.split("\n");
        JMo_List list = new JMo_List();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.internalAdd(new Str(s));
            ++n2;
        }
        return list;
    }

    private Bool match(CallRuntime cr) {
        JMo_Regex par = (JMo_Regex)cr.pars(this, JMo_Regex.class)[0];
        return Bool.getObject(this.value.matches(par.getValue()));
    }

    @Override
    protected Str multi(CallRuntime cr) {
        I_Object par = cr.pars(this, A_IntNumber.class)[0];
        int i = Lib_Convert.getIntValue(cr, par);
        String s = Lib_String.sequence(this.value, (long)i);
        return new Str(s);
    }

    private Str replace(CallRuntime cr) {
        I_Object[] pars = cr.parsExt(this, {I_AtomicValue.class, JMo_Regex.class}, {I_AtomicValue.class});
        String s2 = Lib_Convert.getStringValue(cr, pars[1]);
        if (pars[0] instanceof JMo_Regex) {
            String regex = ((JMo_Regex)pars[0]).getValue();
            try {
                String result = this.value.replaceAll(regex, s2);
                return new Str(result);
            }
            catch (PatternSyntaxException e) {
                throw new ExecError(cr, "Invalid Pattern Syntax", e.getMessage());
            }
        }
        String s1 = Lib_Convert.getStringValue(cr, pars[0]);
        String result = this.value.replace(s1, s2);
        return new Str(result);
    }

    private Str setChar(CallRuntime cr, boolean lazy) {
        I_Object[] pars = cr.pars(this, Char.class, A_IntNumber.class);
        char c = Lib_Convert.getCharValue(cr, pars[0]);
        int pos1 = Lib_Convert.getIntValue(cr, pars[1]);
        int pos = Lib_Sequence.realPos(cr, pos1, this.value.length(), lazy);
        String base = this.value;
        if (pos == -1) {
            int posAbs = Math.abs(pos1);
            if (pos1 < 0) {
                pos = 1;
                base = String.valueOf(Lib_String.sequence(' ', (long)(posAbs - base.length()))) + base;
            } else {
                pos = posAbs;
                base = String.valueOf(base) + Lib_String.sequence(' ', (long)(posAbs - base.length()));
            }
        }
        String result = pos <= 1 ? "" : base.substring(0, pos - 1);
        result = String.valueOf(result) + c;
        result = String.valueOf(result) + base.substring(pos);
        return new Str(result);
    }

    private Str right(CallRuntime cr) {
        int len;
        I_Object par = cr.pars(this, A_IntNumber.class)[0];
        int begin = Lib_Convert.getIntValue(cr, par);
        if (begin > (len = this.value.length())) {
            return this;
        }
        Lib_Error.ifTooSmall(cr, 1L, begin);
        String s = this.value.substring(len - begin);
        return new Str(s);
    }

    private I_Atomic search(CallRuntime cr, boolean first) {
        I_Object par = cr.pars(this, I_Object.class)[0];
        String search = Lib_Convert.getStringValue(cr, par);
        int idx = first ? this.value.indexOf(search) : this.value.lastIndexOf(search);
        return idx < 0 ? Nil.NIL : new Int(idx + 1);
    }

    private Int count(CallRuntime cr) {
        I_Object par = cr.pars(this, Char.class)[0];
        int result = SearchText.countChar(this.value, ((Char)par).getValue().charValue());
        return new Int(result);
    }

    @Override
    protected Str changeChar(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, A_IntNumber.class, A_Chars.class);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        pos = Lib_Sequence.realPos(cr, pos, this.value.length(), false);
        I_Object o = oa[1];
        String n = Lib_Convert.getStringValue(cr, o);
        String l = pos == 1 ? "" : this.value.substring(0, pos - 1);
        String r = pos == this.value.length() ? "" : this.value.substring(pos);
        return new Str(String.valueOf(l) + n + r);
    }

    private JMo_List split(CallRuntime cr) {
        Object par;
        I_Object[] pars = cr.parsFlex(this, 0, 1);
        Object object = par = pars.length == 0 ? null : cr.parTypeExt(pars[0], A_Chars.class, A_IntNumber.class, JMo_Regex.class);
        if (pars.length == 0 || par instanceof Str && ((Str)par).value.length() == 0) {
            JMo_List list = new JMo_List();
            char[] cArray = this.value.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                list.internalAdd(new Char(c));
                ++n2;
            }
            return list;
        }
        if (par instanceof JMo_Regex) {
            String regex = par.toString();
            String[] sa = this.value.split(regex);
            JMo_List list = new JMo_List();
            String[] stringArray = sa;
            int n = sa.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                list.internalAdd(new Str(s));
                ++n3;
            }
            return list;
        }
        if (par instanceof Int) {
            int count = Lib_Convert.getIntValue(cr, (I_Object)par);
            Lib_Error.ifTooSmall(cr, 1L, count);
            JMo_List list = new JMo_List();
            String str = this.value;
            int start = 0;
            while (start < str.length()) {
                list.internalAdd(new Str(str.substring(start, Math.min(str.length(), start + count))));
                start += count;
            }
            return list;
        }
        String delimiter = "" + ((I_AtomicValue)par).getValue();
        I_List<String> sl = ConvText.toList(delimiter, this.value);
        JMo_List list = new JMo_List();
        for (String s : sl) {
            list.internalAdd(new Str(s));
        }
        return list;
    }

    private JMo_List splitKeep(CallRuntime cr) {
        I_Object o = cr.parsExt(this, new Class[][]{{I_AtomicValue.class, JMo_List.class}})[0];
        TypeTable2<String, Boolean> tab = null;
        if (o instanceof I_AtomicValue) {
            tab = ConvText.splitToTable(this.value, o.toString());
        } else if (o instanceof JMo_List) {
            JMo_List delimiters = (JMo_List)o;
            ArrayList<String> al = new ArrayList<String>();
            for (I_Object delimiter : delimiters.getInternalObject()) {
                if (!(delimiter instanceof I_AtomicValue)) {
                    throw new ExecError(cr, "Non-Atomic Delimiter", "Got: " + Lib_Type.getName(delimiter.getClass(), delimiter));
                }
                al.add(Lib_Convert.getStringValue(cr, delimiter));
            }
            tab = ConvText.splitToTable(this.value, al.toArray(new String[al.size()]));
        } else {
            throw Err.todo(o);
        }
        I_List<String> data = tab.getCol1();
        JMo_List list = new JMo_List();
        for (String s : data) {
            list.internalAdd(new Str(s));
        }
        return list;
    }

    private Bool startsWith(CallRuntime cr) {
        I_Object[] pars;
        I_Object[] i_ObjectArray = pars = cr.parsVarArgs(this, 1, 0);
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            String s = Lib_Convert.getStringValue(cr, cr.parType(o, I_AtomicValue.class));
            if (this.value.startsWith(s)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private Str sub(CallRuntime cr) {
        I_Object o = cr.pars(this, I_Object.class)[0];
        return new Str(this.value.replace(Lib_Convert.getStringValue(cr, o), ""));
    }

    private Str endPos(CallRuntime cr) {
        I_Object par = cr.pars(this, A_IntNumber.class)[0];
        int to = Lib_Convert.getIntValue(cr, par);
        if (to == 0) {
            throw new ExecError(cr, "Invalid position in string", "Position can't be 0");
        }
        if (to >= this.value.length()) {
            return new Str(this.value);
        }
        if (to < 0 && Math.abs(to) > this.value.length()) {
            return new Str("");
        }
        if (to < 0) {
            to = this.value.length() + to + 1;
        }
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private Str toFirst(CallRuntime cr, boolean withDelimiter) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 0);
        int idx = -1;
        int dlen = 0;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, par);
            int idx2 = this.value.indexOf(delimiter);
            if (idx2 >= 0 && (idx == -1 || idx2 < idx)) {
                idx = idx2;
                dlen = delimiter.length();
            }
            ++n2;
        }
        if (!withDelimiter) {
            dlen = 0;
        }
        return idx >= 0 ? new Str(this.value.substring(0, idx + dlen)) : this;
    }

    private Str toLast(CallRuntime cr, boolean withDelimiter) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 0);
        int idx = -1;
        int dlen = 0;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, par);
            int idx2 = this.value.lastIndexOf(delimiter);
            if (idx2 >= 0 && (idx == -1 || idx2 > idx)) {
                idx = idx2;
                dlen = delimiter.length();
            }
            ++n2;
        }
        if (!withDelimiter) {
            dlen = 0;
        }
        return idx >= 0 ? new Str(this.value.substring(0, idx + dlen)) : this;
    }

    private Str trim(CallRuntime cr, boolean left, boolean right) {
        I_Object[] pars = cr.parsVarArgs(this, 0, 0);
        if (pars.length == 0) {
            String s = FilterText.trim(this.value, new char[]{' ', '\t', '\r', '\f', '\n'}, left, right);
            return new Str(s);
        }
        char[] ca = new char[pars.length];
        int i = 0;
        while (i < pars.length) {
            ca[i] = ((Char)cr.parType(pars[i], Char.class)).getValue().charValue();
            ++i;
        }
        String s = FilterText.trim(this.value, ca, left, right);
        return new Str(s);
    }

    private I_Object quote(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(this, 0, 1);
        int pari = 2;
        if (pars.length == 1) {
            I_Object par = cr.parType(pars[0], A_IntNumber.class);
            pari = Lib_Convert.getIntValue(cr, par);
        }
        switch (pari) {
            case 1: {
                return new Str(FormString.quote(this.value, '\'', '\\'));
            }
            case 2: {
                return new Str(FormString.quote(this.value, '\"', '\\'));
            }
            case 3: {
                return new Str(FormString.quote(this.value, '\'', '\''));
            }
            case 4: {
                return new Str(FormString.quote(this.value, '\"', '\"'));
            }
        }
        throw new ExecError(cr, "Invalid quote format", "Allowed are 1-4, but got: " + pari);
    }

    private I_Object unquote(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(this, 0, 1);
        int pari = 2;
        if (pars.length == 1) {
            I_Object par = cr.parType(pars[0], A_IntNumber.class);
            pari = Lib_Convert.getIntValue(cr, par);
        }
        switch (pari) {
            case 1: {
                return new Str(FormString.unquote(this.value, '\'', '\\'));
            }
            case 2: {
                return new Str(FormString.unquote(this.value, '\"', '\\'));
            }
            case 3: {
                return new Str(FormString.unquote(this.value, '\'', '\''));
            }
            case 4: {
                return new Str(FormString.unquote(this.value, '\"', '\"'));
            }
        }
        throw new ExecError(cr, "Invalid quote format", "Allowed are 1-4, but got: " + pari);
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.parType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.value.length(), lazy);
        if (pos == -1 || pos > this.value.length()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.value.length(), pos, "position in list");
        }
        if (offset == keys.length - 1) {
            return new Char(this.value.charAt(pos - 1));
        }
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while (j <= offset) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(keys[j].toString());
            ++j;
        }
        throw new ExecError(cr, "Invalid type of item.", "Item at position (" + sb.toString() + ") is a single Char, so I can't go deeper!");
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        throw new ExecError(cr, "Invalid type of item.", "A String is immutable, so it can't be modified!");
    }
}

