/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import java.util.ArrayList;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.A_Atomic;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.struct.JMo_List;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_MagicVar;

public class Nil
extends A_Atomic
implements I_Atomic {
    public static final Nil NIL = new Nil();

    private Nil() {
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.multiply(cr));
            }
        }
        Lib_MagicVar.checkForbiddenFuncs(cr, method);
        return null;
    }

    public static JMo_List arithmetic(CallRuntime cr, A_Number.NOP1 op, int intValue) {
        if (op == A_Number.NOP1.MUL) {
            ArrayList<I_Object> al = new ArrayList<I_Object>(intValue);
            int i = 0;
            while (i < intValue) {
                al.add(NIL);
                ++i;
            }
            return new JMo_List(al);
        }
        throw new CodeError(cr, "Invalid function for Nil", op.toString());
    }

    private I_Object multiply(CallRuntime cr) {
        I_Object par = cr.pars(this, A_IntNumber.class)[0];
        int amount = Lib_Convert.getIntValue(cr, par);
        return Nil.arithmetic(cr, A_Number.NOP1.MUL, amount);
    }

    @Override
    public Object getValue() {
        return NIL;
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof Nil) {
            return 0;
        }
        return null;
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return "nil";
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return NIL;
    }

    @Override
    protected Bool comparsion(CallRuntime cr, COMPARE m) {
        throw new ExecError(cr, "Nil Exception", "Object is nil");
    }

    @Override
    protected Int length(CallRuntime cr) {
        return new Int(3);
    }
}

