/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object.atom;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.convert.ConvChar;
import de.mn77.base.error.Err;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_Chars;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.I_Atomic;
import org.jmo_lang.object.atom.I_AtomicValue;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Nil;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.COMPARE;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.ATOMIC;
import org.jmo_lang.tools.Lib_AtomConv;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Sequence;

public class Char
extends A_Chars
implements I_Atomic {
    private final char value;

    public Char(char val) {
        this.value = val;
    }

    @Override
    protected ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "++": 
            case "inc": {
                return A_Object.stdResult(this.incDec(cr, true));
            }
            case "--": 
            case "dec": {
                return A_Object.stdResult(this.incDec(cr, false));
            }
            case "/": 
            case "div": {
                throw new ExecError(cr, "One single character cannot be split.", "Char: " + this.toString() + " / \u2026");
            }
            case "-": 
            case "sub": {
                throw new ExecError(cr, "Cannot subtract anything from a single character.", "Char: " + this.toString() + " - \u2026");
            }
            case "rangeTo": {
                return A_Object.stdResult(this.range(cr));
            }
            case "eachTo": {
                return this.eachTo(cr);
            }
            case "ord": {
                return A_Object.stdResult(this.ord(cr));
            }
            case "alphabet": {
                return A_Object.stdResult(this.alphabet(cr));
            }
            case "toUnicode": 
            case "unicode": {
                return A_Object.stdResult(this.unicode(cr));
            }
            case "isNumber": {
                return A_Object.stdResult(Bool.getObject(Character.isDigit(this.value)));
            }
            case "isLetter": {
                return A_Object.stdResult(Bool.getObject(Character.isLetter(this.value)));
            }
            case "isCaseUp": {
                return A_Object.stdResult(Bool.getObject(Character.isUpperCase(this.value)));
            }
            case "isCaseDown": {
                return A_Object.stdResult(Bool.getObject(Character.isLowerCase(this.value)));
            }
        }
        return null;
    }

    private I_Object unicode(CallRuntime cr) {
        cr.pars();
        return new Str(ConvChar.getUnicode(this.value));
    }

    @Override
    protected Char caseDown(CallRuntime cr) {
        cr.pars();
        return new Char(("" + this.value).toLowerCase().charAt(0));
    }

    @Override
    protected Char caseUp(CallRuntime cr) {
        cr.pars();
        return new Char(("" + this.value).toUpperCase().charAt(0));
    }

    @Override
    protected I_Object charAt(CallRuntime cr, boolean lazy) {
        int pos = Lib_Convert.getIntValue(cr, cr.pars(this, A_IntNumber.class)[0]);
        if ((pos = Lib_Sequence.realPos(cr, pos, 1, lazy)) != 1) {
            return Nil.NIL;
        }
        return this;
    }

    @Override
    protected Char changeChar(CallRuntime cr) {
        I_Object[] oa = cr.pars(this, A_IntNumber.class, A_Chars.class);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        pos = Lib_Sequence.realPos(cr, pos, 1, false);
        I_Object o = oa[1];
        String n = Lib_Convert.getStringValue(cr, o);
        return new Char(n.charAt(0));
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof Char) {
            return new Character(this.value).compareTo(((Char)o).getValue());
        }
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.CHAR, to, this, this.getValue());
    }

    @Override
    public Character getValue() {
        return Character.valueOf(this.value);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "'" + this.value + "'";
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    protected Bool comparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.pars(this, A_Chars.class)[0];
        String par = Lib_Convert.getStringValue(cr, o);
        String val = "" + this.value;
        switch (m) {
            case G: {
                return Bool.getObject(val.compareTo(par) > 0);
            }
            case L: {
                return Bool.getObject(val.compareTo(par) < 0);
            }
            case GE: {
                return Bool.getObject(val.compareTo(par) >= 0);
            }
            case LE: {
                return Bool.getObject(val.compareTo(par) <= 0);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected Str add(CallRuntime cr) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 0);
        String result = "" + this.value;
        I_Object[] i_ObjectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object par = i_ObjectArray[n2];
            String par2 = Lib_Convert.getStringValue(cr, par);
            result = String.valueOf(result) + par2;
            ++n2;
        }
        return new Str(result);
    }

    private Char incDec(CallRuntime cr, boolean inc) {
        I_Object[] oa = cr.parsFlex(this, 0, 1);
        if (oa.length == 0) {
            return new Char((char)(inc ? this.value + '\u0001' : this.value - '\u0001'));
        }
        I_AtomicValue o = (I_AtomicValue)cr.parType(oa[0], I_AtomicValue.class);
        int par = Lib_Convert.getIntValue(cr, o);
        char val = this.value;
        int res = inc ? val + par : val - par;
        return new Char((char)res);
    }

    @Override
    protected Str multi(CallRuntime cr) {
        I_Object par = cr.pars(this, A_IntNumber.class)[0];
        int i = Lib_Convert.getIntValue(cr, par);
        String s = Lib_String.sequence(this.value, (long)i);
        return new Str(s);
    }

    private JMo_Range range(CallRuntime cr) {
        I_Object to = cr.pars(this, Char.class)[0];
        return JMo_Range.createNew(cr, this, to);
    }

    private ObjectCallResult eachTo(CallRuntime cr) {
        I_Object to = cr.pars(this, Char.class)[0];
        JMo_Range range = JMo_Range.createNew(cr, this, to);
        if (cr.call.getBlock() == null && cr.call.getStream() == null) {
            return A_Object.stdResult(range);
        }
        range.init(cr);
        return new ObjectCallResult(range.autoBlockDo(cr), true);
    }

    private Int ord(CallRuntime cr) {
        cr.pars();
        char ord = this.value;
        return new Int(ord);
    }

    private Int alphabet(CallRuntime cr) {
        cr.pars();
        char ord = this.value;
        if (ord >= 'A' && ord <= 'Z') {
            return new Int(ord - 64);
        }
        if (ord >= 'a' && ord <= 'z') {
            return new Int(ord - 96);
        }
        return new Int(-1);
    }
}

