/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.error.Err;
import de.mn77.base.thread.MTimer;
import java.util.TimerTask;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.struct.Block;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Timer
extends A_Object
implements I_Object {
    private final MTimer timer = new MTimer();

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "cycle": 
            case "every": {
                return this.every(cr);
            }
            case "stop": {
                return A_Object.stdResult(this.stop(cr));
            }
            case "wait": {
                return this.wait(cr);
            }
        }
        return null;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        super.describe(cr, left);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return Lib_Type.getName(this);
    }

    private ObjectCallResult every(final CallRuntime cr) {
        Int ms = (Int)cr.pars(this, Int.class)[0];
        final Call stream = cr.getStream();
        final Block block = cr.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(cr, "Invalid call", "No stream, no block, for timer ... what to do?");
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                JMo_Timer.this.syncGo(cr, block, stream);
            }
        };
        this.timer.addCycle(ms.getValue(), task);
        return new ObjectCallResult(this, true);
    }

    private JMo_Timer stop(CallRuntime cr) {
        cr.pars();
        this.timer.stop();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncGo(CallRuntime cr, Block block, Call stream) {
        JMo_Timer jMo_Timer = this;
        synchronized (jMo_Timer) {
            try {
                if (block != null) {
                    block.exec(cr, null);
                }
                if (stream != null) {
                    cr.execInit(stream, null);
                }
            }
            catch (Throwable t) {
                Err.show(t);
            }
        }
    }

    private ObjectCallResult wait(final CallRuntime cr) {
        Int ms = (Int)cr.pars(this, Int.class)[0];
        final Call stream = cr.getStream();
        final Block block = cr.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(cr, "Invalid call", "No stream, no block, for timer ... what to do?");
        }
        this.timer.execLater(ms.getValue(), new TimerTask(){

            @Override
            public void run() {
                JMo_Timer.this.syncGo(cr, block, stream);
            }
        });
        return new ObjectCallResult(this, true);
    }
}

