/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.object;

import de.mn77.base.data.Lib_Random;
import org.jmo_lang.error.ExecError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.object.JMo_Range;
import org.jmo_lang.object.atom.A_IntNumber;
import org.jmo_lang.object.atom.A_Number;
import org.jmo_lang.object.atom.Bool;
import org.jmo_lang.object.atom.Char;
import org.jmo_lang.object.atom.Dec;
import org.jmo_lang.object.atom.I_Integer;
import org.jmo_lang.object.atom.Int;
import org.jmo_lang.object.atom.Str;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Error;

public class JMo_Random
extends A_Object
implements I_Object {
    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "newInt": 
            case "int": {
                return A_Object.stdResult(this.getInt(cr));
            }
            case "newDec": 
            case "dec": {
                return A_Object.stdResult(this.getDec(cr));
            }
            case "bool": 
            case "newBool": {
                return A_Object.stdResult(this.getBool(cr));
            }
            case "char": 
            case "newChar": {
                return A_Object.stdResult(this.getChar(cr));
            }
            case "newStr": 
            case "string": 
            case "newString": 
            case "str": {
                return A_Object.stdResult(this.getStr(cr));
            }
        }
        return null;
    }

    @Override
    public void describe(CallRuntime cr, int left) {
        super.describe(cr, left);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return "Random";
    }

    @Override
    public String toString() {
        return "Random";
    }

    private Bool getBool(CallRuntime cr) {
        cr.pars();
        boolean r = Lib_Random.getBool();
        return Bool.getObject(r);
    }

    private Int getInt(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(this, 0, 2);
        int len = pars.length;
        if (len == 0) {
            int r = Lib_Random.getInt();
            return new Int(r);
        }
        if (len == 1) {
            I_Object p1 = cr.parType(pars[0], A_IntNumber.class);
            int i1 = Lib_Convert.getIntValue(cr, p1);
            int r = Lib_Random.getInt(1, i1);
            return new Int(r);
        }
        I_Object p1 = cr.parType(pars[0], A_IntNumber.class);
        I_Object p2 = cr.parType(pars[1], A_IntNumber.class);
        int i1 = Lib_Convert.getIntValue(cr, p1);
        int i2 = Lib_Convert.getIntValue(cr, p2);
        Lib_Error.ifTooSmall(cr, i1, i2);
        int r = Lib_Random.getInt(i1, i2);
        return new Int(r);
    }

    private Dec getDec(CallRuntime cr) {
        I_Object[] pars = cr.parsFlex(this, 0, 2);
        int len = pars.length;
        if (len == 0) {
            double r = Lib_Random.getDouble(Double.MIN_VALUE, Double.MAX_VALUE);
            return new Dec(r);
        }
        if (len == 1) {
            I_Object p1 = cr.parType(pars[0], A_Number.class);
            double d1 = Lib_Convert.getDoubleValue(cr, p1);
            double r = Lib_Random.getDouble(1.0, d1);
            return new Dec(r);
        }
        I_Object p1 = cr.parType(pars[0], A_Number.class);
        I_Object p2 = cr.parType(pars[1], A_Number.class);
        double d1 = Lib_Convert.getDoubleValue(cr, p1);
        double d2 = Lib_Convert.getDoubleValue(cr, p2);
        double r = Lib_Random.getDouble(d1, d2);
        return new Dec(r);
    }

    private Char getChar(CallRuntime cr) {
        I_Object[] pars = cr.parsVarArgs(this, 0, 0);
        String source = pars.length > 0 ? this.iParsToSource(cr, pars, 0) : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        int r = Lib_Random.getInt(0, source.length() - 1);
        return new Char(source.charAt(r));
    }

    private Str getStr(CallRuntime cr) {
        I_Object[] pars = cr.parsVarArgs(this, 1, 1);
        int len = Lib_Convert.getIntValue(cr, cr.parType(pars[0], A_IntNumber.class));
        String source = this.iParsToSource(cr, pars, 1);
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i <= len) {
            int r = Lib_Random.getInt(0, source.length() - 1);
            sb.append(source.charAt(r));
            ++i;
        }
        return new Str(sb.toString());
    }

    private String iParsToSource(CallRuntime cr, I_Object[] pars, int offset) {
        String source = "";
        int i = offset;
        while (i < pars.length) {
            I_Object par = pars[i];
            I_Object p = cr.parType(par, I_Object.class);
            if (p instanceof Str) {
                source = String.valueOf(source) + ((Str)p).getValue();
            } else if (p instanceof Char) {
                source = String.valueOf(source) + ((Char)p).getValue();
            } else if (p instanceof JMo_Range) {
                source = String.valueOf(source) + ((JMo_Range)p).calcString(cr);
            } else if (p instanceof I_Integer) {
                int val = Lib_Convert.getIntValue(cr, p);
                Lib_Error.ifNotBetween(cr, 0, 9, val, "Integer-Number");
                source = String.valueOf(source) + val;
            } else {
                throw new ExecError(cr, "Invalid parameter", "Only Str, Char, Range, Integer-Values(0-9) are allowed. Got: " + par);
            }
            ++i;
        }
        if (source.length() == 0) {
            throw new ExecError(cr, "Invalid parameter", "No sources available");
        }
        return source;
    }
}

