/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.error;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.convert.ConvSequ;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.error.I_Error;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jmo_lang.error.DebugInfo;
import org.jmo_lang.error.ERROR_GROUP;
import org.jmo_lang.error.ErrorBase;
import org.jmo_lang.struct.runtime.CallRuntime;

public class ErrorBaseDebug
extends ErrorBase
implements I_Error {
    private static final long serialVersionUID = 8587625424636880857L;
    private final DebugInfo source;
    private final String call;
    private final String instance;
    private final ERROR_GROUP group;

    protected ErrorBaseDebug(ERROR_GROUP group, String message, String call, String detail, CallRuntime cr, DebugInfo source) {
        super(message, detail);
        this.group = group;
        this.source = source;
        this.call = call;
        this.instance = cr == null ? null : cr.instance.toDebug(cr);
    }

    @Override
    public Iterable<Object> getDetails() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.getDetail() != null) {
            list.add("Detail  : " + this.iLimit(this.getDetail()));
        }
        if (this.source != null) {
            list.add("Source  : " + this.source);
        }
        if (this.call != null) {
            list.add("Call    : " + this.iLimit(this.call));
        }
        if (this.instance != null) {
            list.add("Instance: " + this.instance);
        }
        return list;
    }

    private String iLimit(String s) {
        int max = 400;
        return s.length() < 400 ? s : String.valueOf(s.substring(0, 400)) + "...";
    }

    public String getCall() {
        return this.call;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getSource() {
        return "" + this.source;
    }

    public ERROR_GROUP getGroup() {
        return this.group;
    }

    @Override
    public void addDetail(Object ... oa) {
        Err.todo(oa);
    }

    public String toInfo() {
        MList<String> list = new MList<String>();
        String className = this.getClass().getSimpleName();
        String grp = this.group != null ? String.valueOf(this.group.detail) + " (" + className + ")" : className;
        list.add("Error   : " + grp);
        list.add("Message : " + this.getMessage());
        for (Object d : this.getDetails()) {
            list.add(ConvObject.toText(d));
        }
        return ConvSequ.toText(MOut.getLineBreak(), list);
    }
}

