/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang.dev;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import org.jmo_lang.dev.JMo_Object;
import org.jmo_lang.dev.Toolbox;
import org.jmo_lang.error.CodeError;
import org.jmo_lang.object.A_Object;
import org.jmo_lang.object.I_Object;
import org.jmo_lang.struct.App;
import org.jmo_lang.struct.Call;
import org.jmo_lang.struct.ObjectCallResult;
import org.jmo_lang.struct.runtime.CallRuntime;
import org.jmo_lang.tools.Lib_Convert;
import org.jmo_lang.tools.Lib_Java;
import org.jmo_lang.tools.Lib_Type;

public class JMo_Sandbox
extends A_Object {
    private final JMo_Object obj;
    private final Call[] pars;
    private final Toolbox toolbox;

    public JMo_Sandbox(App app, Class<? extends JMo_Object> type, Call[] pars) {
        this.pars = pars;
        try {
            this.obj = type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Err_Exception e2 = Err.wrap(e, "Maybe the object has no blank constructor");
            throw Err.exit(e2);
        }
        this.toolbox = new Toolbox(app);
    }

    @Override
    public void init(CallRuntime cr) {
        int len = this.pars == null ? 0 : this.pars.length;
        Object[] pars2 = new Object[len];
        int p = 0;
        while (p < len) {
            I_Object o = Lib_Convert.getValue(cr, cr.execInit(this.pars[p], null));
            pars2[p] = Lib_Java.jmoToJava(o);
            ++p;
        }
        try {
            this.obj.init(pars2);
        }
        catch (Throwable t) {
            throw new CodeError(cr, "Can't instantiate Object", t.getMessage());
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        I_Object[] pars = cr.parsVarArgs(this, 0, 0);
        Object[] pars2 = new Object[pars.length];
        int p = 0;
        while (p < pars.length) {
            pars2[p] = Lib_Java.jmoToJava(pars[p]);
            ++p;
        }
        Object o = null;
        try {
            o = this.obj.call(method, pars2, this.toolbox);
        }
        catch (Throwable t) {
            throw new CodeError(cr, "Execution error", t.getMessage());
        }
        if (o == null) {
            return null;
        }
        I_Object o2 = Lib_Java.javaToJmo(o);
        return A_Object.stdResult(o2);
    }

    @Override
    public String toDebug(CallRuntime cr) {
        return this.toString();
    }

    @Override
    public String toString() {
        return Lib_Type.getName(this.obj.getClass(), null);
    }
}

