/*
 * Decompiled with CFR 0.152.
 */
package org.jmo_lang;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import de.mn77.base.version.VersionData_ABC;
import java.io.IOException;
import org.jmo_lang.cli.CLI;
import org.jmo_lang.parser.Parser_App;
import org.jmo_lang.struct.App;

public class JMo {
    public static final VersionData_ABC VERSION = new VersionData_ABC(0, 16, 0, 0);
    public static final String PACKAGE_DOMAIN_BASE = "org.jmo_lang";
    private boolean parseOnly = false;
    private String singleLine = null;
    private boolean debug = false;

    public static void main(String[] args) {
        MOut.debugNo();
        MOut.setJavaErrors(false);
        try {
            JMo jmo = new JMo();
            jmo.start(args);
        }
        catch (Throwable t) {
            Err.exit(t);
        }
    }

    public void start(String[] args) throws Err_FileSys, IOException {
        if ((args = this.args(args)).length == 0 && this.singleLine == null) {
            CLI cli = new CLI();
            cli.start(this.parseOnly, this.debug);
            return;
        }
        Parser_App parser = new Parser_App();
        App app = null;
        if (this.singleLine != null) {
            app = parser.parseText(this.singleLine.trim());
        } else {
            MFile datei = new MFile(args[0]);
            if (!datei.exists()) {
                MOut.text("Missing file: " + datei.getPathAbsolute());
                return;
            }
            app = parser.parseFile(datei);
            int len = args.length - 1;
            String[] args_tmp = new String[len];
            if (len > 0) {
                System.arraycopy(args, 1, args_tmp, 0, len);
            }
            args = args_tmp;
        }
        if (this.debug) {
            app.setDebug();
        }
        if (this.parseOnly) {
            MOut.text("Test okay, no parse errors found.");
        } else {
            app.exec(args);
        }
    }

    private String[] args(String[] args) {
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            if (!s.startsWith("-")) {
                if (i == 0) {
                    return args;
                }
                return this.shortenArray(args, i);
            }
            switch (s) {
                case "-t": 
                case "--test": {
                    this.parseOnly = true;
                    break;
                }
                case "--debug": 
                case "-d": {
                    this.debug = true;
                    MOut.setJavaErrors(true);
                    MOut.debugDetail();
                    break;
                }
                case "-e": 
                case "--exec": {
                    int len = args.length - i - 1;
                    if (len == 0) {
                        throw new Err_Runtime("Invalid arguments", "Missing code after \"-e/--exec\"");
                    }
                    this.singleLine = args[++i];
                    break;
                }
                default: {
                    throw new Err_Runtime("Unknown argument for JM\u00b0", s);
                }
            }
            ++i;
        }
        return new String[0];
    }

    private String[] shortenArray(String[] args, int start) {
        int newLen = args.length - start;
        String[] args2 = new String[newLen];
        System.arraycopy(args, start, args2, 0, newLen);
        return args2;
    }
}

