/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.stream;

import de.mn77.base.error.Err;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class UTF8OutputStream
extends OutputStream {
    boolean closed = false;
    private final ArrayList<Byte> buffer = new ArrayList();

    @Override
    public void write(int c) throws IOException {
        if (this.closed) {
            Err.forbidden("Stream is closed!");
        }
        this.buffer.add((byte)c);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public String getString() {
        if (!this.closed) {
            Err.forbidden("Stream not closed!");
        }
        try {
            byte[] ba = new byte[this.buffer.size()];
            int i = 0;
            while (i < this.buffer.size()) {
                ba[i] = this.buffer.get(i);
                ++i;
            }
            return new String(ba, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw Err.exit(e2);
        }
    }
}

