/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.tree;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import java.util.Iterator;

public class MTreeNode<TKey, TValue>
implements I_Sequence {
    public final ArrayList<MTreeNode<TKey, TValue>> nodes = new ArrayList();
    private TKey name = null;
    private TValue value = null;

    public MTreeNode(TKey name) {
        this.name = name;
    }

    public MTreeNode(TKey name, TValue value) {
        Err.ifNull(name);
        this.name = name;
        this.value = value;
    }

    @Override
    public void describe() {
        MList<String> target = new MList<String>();
        for (MTreeNode<TKey, TValue> node : this.nodes) {
            super.describe(target, 0);
        }
        for (String s : target) {
            MOut.text(s);
        }
    }

    private void describe(I_List<String> target, int left) {
        target.add(String.valueOf(Lib_String.sequence(' ', (long)(left * 2))) + this.toString());
        for (MTreeNode<TKey, TValue> node : this.nodes) {
            super.describe(target, left + 1);
        }
    }

    public String toString() {
        return String.valueOf(this.name == null ? "Tree" : this.name.toString()) + (this.value == null ? "" : ": " + this.value.toString());
    }

    public MTreeNode<TKey, TValue> first() {
        return this.nodes.size() == 0 ? null : this.nodes.get(0);
    }

    public MTreeNode<TKey, TValue> last() {
        return this.nodes.size() == 0 ? null : this.nodes.get(this.nodes.size() - 1);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.size() == 0;
    }

    private MTreeNode<TKey, TValue> get(TKey key) {
        return this.iGetPull(key, false);
    }

    private MTreeNode<TKey, TValue> pull(TKey key) {
        return this.iGetPull(key, true);
    }

    private MTreeNode<TKey, TValue> iGetPull(TKey key, boolean lazy) {
        for (MTreeNode<TKey, TValue> node : this.nodes) {
            if (!node.name.equals(key)) continue;
            return node;
        }
        if (lazy) {
            MTreeNode<TKey, TValue> node;
            node = new MTreeNode<TKey, TValue>(key);
            this.nodes.add(node);
            return node;
        }
        throw new Err_Runtime("Can't find node with name: \"" + key + '\"', new Object[0]);
    }

    public void set(TKey key, TValue value) {
        this.iSetPut(key, value, false);
    }

    public void put(TKey key, TValue value) {
        this.iSetPut(key, value, true);
    }

    private void iSetPut(TKey key, TValue value, boolean lazy) {
        MTreeNode<TKey, TValue> found = null;
        for (MTreeNode<TKey, TValue> node : this.nodes) {
            if (!node.name.equals(key)) continue;
            found = node;
        }
        if (lazy && found == null) {
            MTreeNode<TKey, TValue> node;
            node = new MTreeNode<TKey, TValue>(key);
            this.nodes.add(node);
            found = node;
        }
        if (found == null) {
            throw new Err_Runtime("Can't find node with name: \"" + key + '\"', new Object[0]);
        }
        found.value = value;
    }

    public void setName(TKey name) {
        Err.ifNull(name);
        this.name = name;
    }

    public TKey getName() {
        return this.name;
    }

    public void setValue(TValue value) {
        this.value = value;
    }

    public TValue getValue() {
        return this.value;
    }

    public MTreeNode<TKey, TValue> add(TKey key) {
        MTreeNode<TKey, TValue> result = new MTreeNode<TKey, TValue>(key);
        this.nodes.add(result);
        return result;
    }

    public MTreeNode<TKey, TValue> add(TKey key, TValue value) {
        MTreeNode<TKey, TValue> result = new MTreeNode<TKey, TValue>(key, value);
        this.nodes.add(result);
        return result;
    }

    public void add(MTreeNode<TKey, TValue> node) {
        this.nodes.add(node);
    }

    public void addNodes(TKey ... keys) {
        TKey[] TKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            TKey key = TKeyArray[n2];
            this.nodes.add(new MTreeNode<TKey, TValue>(key));
            ++n2;
        }
    }

    public void addNodes(MTreeNode<TKey, TValue> ... nodes) {
        MTreeNode<TKey, TValue>[] mTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            MTreeNode<TKey, TValue> node = mTreeNodeArray[n2];
            this.nodes.add(node);
            ++n2;
        }
    }

    public void removeNodes(TKey ... keys) {
        TKey[] TKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            TKey key = TKeyArray[n2];
            boolean removed = false;
            int i = 0;
            while (i < this.nodes.size()) {
                MTreeNode<TKey, TValue> node = this.nodes.get(i);
                if (node.name.equals(key)) {
                    this.nodes.remove(i);
                    removed = true;
                    break;
                }
                ++i;
            }
            if (!removed) {
                throw new Err_Runtime("Can't find node with name: \"" + key + '\"', new Object[0]);
            }
            ++n2;
        }
    }

    @Override
    public Iterator<MTreeNode<TKey, TValue>> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public String toStringDebug() {
        return this.toString();
    }

    @Override
    public TValue copy() {
        throw Err.todo(new Object[0]);
    }

    public MTreeNode<TKey, TValue> get(int position) {
        return this.nodes.get(position - 1);
    }
}

